/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityTurret
extends TileEntityIEBase
implements ITickable,
EnergyHelper.IIEInternalFluxHandler,
IIEInventory,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.ITileDrop,
IEBlockInterfaces.IDirectionalTile,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IGuiTile,
IEBlockInterfaces.IEntityProof,
IEBlockInterfaces.IHammerInteraction,
IEBlockInterfaces.IHasObjProperty {
    public boolean dummy = false;
    public FluxStorage energyStorage = new FluxStorage(16000);
    public boolean redstoneControlInverted = false;
    public EnumFacing facing = EnumFacing.NORTH;
    public String owner;
    public List<String> targetList = new ArrayList<String>();
    public boolean whitelist = false;
    public boolean attackAnimals = false;
    public boolean attackPlayers = false;
    public boolean attackNeutrals = false;
    protected int tick = 0;
    protected EntityLivingBase target;
    public float rotationYaw;
    public float rotationPitch;
    private UUID targetId;
    AxisAlignedBB renderBB;
    EnergyHelper.IEForgeEnergyWrapper[] wrappers = EnergyHelper.IEForgeEnergyWrapper.getDefaultWrapperArray(this);
    static ArrayList<String> displayList = Lists.newArrayList((Object[])new String[]{"base"});

    public void func_73660_a() {
        ApiUtils.checkForNeedlessTicking(this);
        if (this.dummy) {
            return;
        }
        double range = this.getRange();
        if (this.targetId != null) {
            AxisAlignedBB validBox = Block.field_185505_j.func_186670_a(this.field_174879_c).func_186662_g(range);
            List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, validBox);
            for (EntityLivingBase entity : entities) {
                if (!entity.func_110124_au().equals(this.targetId) || !this.isValidTarget(entity, true)) continue;
                this.target = entity;
                break;
            }
            this.targetId = null;
        }
        if (this.target != null) {
            Vec3d delta = this.getGunToTargetVec(this.target);
            double dSq = delta.func_189985_c();
            if (dSq > range * range) {
                this.target = null;
            } else if (this.field_145850_b.field_72995_K) {
                float facingYaw = this.facing == EnumFacing.NORTH ? 180.0f : (this.facing == EnumFacing.WEST ? -90.0f : (this.facing == EnumFacing.EAST ? 90.0f : 0.0f));
                double yaw = MathHelper.func_181159_b((double)delta.field_72450_a, (double)delta.field_72449_c) * 57.29577951308232 - (double)facingYaw;
                this.rotationPitch = (float)(Math.atan2(Math.sqrt(delta.field_72450_a * delta.field_72450_a + delta.field_72449_c * delta.field_72449_c), delta.field_72448_b) * 57.29577951308232) - 90.0f;
                this.rotationYaw = this.rotationYaw == 0.0f ? (float)(yaw * 0.5) : (float)yaw;
            }
        } else if (this.field_145850_b.field_72995_K) {
            this.rotationYaw = (float)((double)this.rotationYaw * 0.75);
            if (Math.abs(this.rotationYaw) < 10.0f) {
                this.rotationYaw = 0.0f;
            }
            this.rotationPitch = (float)((double)this.rotationPitch * 0.75);
            if (Math.abs(this.rotationPitch) < 10.0f) {
                this.rotationPitch = 0.0f;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 64L == (long)((this.func_174877_v().func_177958_n() ^ this.func_174877_v().func_177952_p()) & 0x3F)) {
            this.markContainingBlockForUpdate(null);
        }
        int energy = Config.IEConfig.Machines.turret_consumption;
        if (this.field_145850_b.func_175687_A(this.func_174877_v()) > 0 ^ this.redstoneControlInverted) {
            if (this.energyStorage.extractEnergy(energy, true) == energy) {
                this.energyStorage.extractEnergy(energy, false);
                if (this.target == null || this.target.field_70128_L || this.field_145850_b.func_73045_a(this.target.func_145782_y()) == null || this.target.func_110143_aJ() <= 0.0f || !this.canShootEntity(this.target)) {
                    this.target = this.getTarget();
                    if (this.target != null) {
                        this.func_70296_d();
                        this.markContainingBlockForUpdate(null);
                    }
                }
                if (this.target != null && this.canActivate()) {
                    ++this.tick;
                    int chargeup = this.getChargeupTicks();
                    if (this.tick == chargeup) {
                        this.activate();
                    } else if (this.tick > chargeup) {
                        if (this.loopActivation()) {
                            this.activate();
                        } else if (this.tick == chargeup + this.getActiveTicks()) {
                            this.tick = 0;
                        }
                    }
                } else {
                    this.tick = 0;
                }
            }
        } else if (this.target != null) {
            this.target = null;
        }
    }

    private boolean canShootEntity(EntityLivingBase entity) {
        Vec3d end;
        Vec3d start = this.getGunPosition();
        if (Utils.rayTraceForFirst(start, end = this.getTargetVector(entity), this.field_145850_b, Collections.singleton(this.func_174877_v().func_177984_a())) != null) {
            return false;
        }
        AxisAlignedBB potentialCollateralArea = entity.func_174813_aQ().func_111270_a(new AxisAlignedBB(this.field_174879_c.func_177984_a()));
        List potentialCollateral = this.field_145850_b.func_72872_a(EntityLivingBase.class, potentialCollateralArea);
        for (EntityLivingBase coll : potentialCollateral) {
            AxisAlignedBB entityBB = coll.func_174813_aQ().func_186662_g(0.4625);
            if (this.isValidTarget(coll, false) || entityBB.func_72327_a(start, end) == null) continue;
            return false;
        }
        return true;
    }

    protected Vec3d getTargetVector(EntityLivingBase e) {
        return new Vec3d(e.field_70165_t, e.field_70163_u + 0.5 * (double)e.func_70047_e(), e.field_70161_v);
    }

    protected Vec3d getGunPosition() {
        return new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.375, (double)this.field_174879_c.func_177952_p() + 0.5);
    }

    protected Vec3d getGunToTargetVec(EntityLivingBase target) {
        return this.getGunPosition().func_72444_a(this.getTargetVector(target));
    }

    @Nullable
    private EntityLivingBase getTarget() {
        double range = this.getRange();
        List list = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - range, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() - range, (double)this.func_174877_v().func_177958_n() + range, (double)(this.func_174877_v().func_177956_o() + 3), (double)this.func_174877_v().func_177952_p() + range));
        if (list.isEmpty()) {
            return null;
        }
        for (EntityLivingBase entity : list) {
            if (!this.isValidTarget(entity, true)) continue;
            return entity;
        }
        return null;
    }

    public boolean isValidTarget(EntityLivingBase entity, boolean checkCanShoot) {
        Entity entityOwner;
        if (entity == null || entity.field_70128_L || entity.func_110143_aJ() <= 0.0f) {
            return false;
        }
        if (this.whitelist ^ this.isListedName(this.targetList, entity.func_70005_c_())) {
            return false;
        }
        if (entity instanceof IEntityOwnable && (entityOwner = ((IEntityOwnable)entity).func_70902_q()) != null && this.whitelist ^ this.isListedName(this.targetList, entityOwner.func_70005_c_())) {
            return false;
        }
        if (entity instanceof EntityAnimal && !this.attackAnimals) {
            return false;
        }
        if (entity instanceof EntityPlayer && !this.attackPlayers) {
            return false;
        }
        if (!(entity instanceof EntityPlayer || entity instanceof EntityAnimal || entity.isCreatureType(EnumCreatureType.MONSTER, false) || this.attackNeutrals)) {
            return false;
        }
        if (this.target == null || entity.func_174818_b(this.func_174877_v()) < this.target.func_174818_b(this.func_174877_v())) {
            return true;
        }
        return !checkCanShoot || this.canShootEntity(entity);
    }

    private boolean isListedName(List<String> list, String name) {
        for (String s : list) {
            if (!name.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    protected abstract double getRange();

    protected abstract boolean canActivate();

    protected abstract int getChargeupTicks();

    protected abstract int getActiveTicks();

    protected abstract boolean loopActivation();

    protected abstract void activate();

    protected boolean hasOwnerRights(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || this.owner == null || this.owner.isEmpty()) {
            return true;
        }
        return this.owner.equalsIgnoreCase(player.func_70005_c_());
    }

    @Override
    public void receiveMessageFromClient(NBTTagCompound message) {
        if (message.func_74764_b("add")) {
            this.targetList.add(message.func_74779_i("add"));
        }
        if (message.func_74764_b("remove")) {
            this.targetList.remove(message.func_74762_e("remove"));
        }
        if (message.func_74764_b("whitelist")) {
            this.whitelist = message.func_74767_n("whitelist");
        }
        if (message.func_74764_b("attackAnimals")) {
            this.attackAnimals = message.func_74767_n("attackAnimals");
        }
        if (message.func_74764_b("attackPlayers")) {
            this.attackPlayers = message.func_74767_n("attackPlayers");
        }
        if (message.func_74764_b("attackNeutrals")) {
            this.attackNeutrals = message.func_74767_n("attackNeutrals");
        }
        this.target = null;
        this.func_70296_d();
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        this.dummy = nbt.func_74767_n("dummy");
        this.redstoneControlInverted = nbt.func_74767_n("redstoneInverted");
        this.facing = EnumFacing.func_82600_a((int)nbt.func_74762_e("facing"));
        this.energyStorage.readFromNBT(nbt);
        if (nbt.func_74764_b("owner")) {
            this.owner = nbt.func_74779_i("owner");
        }
        NBTTagList list = nbt.func_150295_c("targetList", 8);
        this.targetList.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.targetList.add(list.func_150307_f(i));
        }
        this.whitelist = nbt.func_74767_n("whitelist");
        this.attackAnimals = nbt.func_74767_n("attackAnimals");
        this.attackPlayers = nbt.func_74767_n("attackPlayers");
        this.attackNeutrals = nbt.func_74767_n("attackNeutrals");
        this.target = null;
        if (nbt.func_150297_b("target", 8)) {
            this.targetId = UUID.fromString(nbt.func_74779_i("target"));
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        nbt.func_74757_a("dummy", this.dummy);
        nbt.func_74757_a("redstoneInverted", this.redstoneControlInverted);
        if (this.facing != null) {
            nbt.func_74768_a("facing", this.facing.ordinal());
        }
        this.energyStorage.writeToNBT(nbt);
        if (this.owner != null) {
            nbt.func_74778_a("owner", this.owner);
        }
        NBTTagList list = new NBTTagList();
        for (String s : this.targetList) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        nbt.func_74782_a("targetList", (NBTBase)list);
        nbt.func_74757_a("whitelist", this.whitelist);
        nbt.func_74757_a("attackAnimals", this.attackAnimals);
        nbt.func_74757_a("attackPlayers", this.attackPlayers);
        nbt.func_74757_a("attackNeutrals", this.attackNeutrals);
        if (this.target != null) {
            nbt.func_74778_a("target", this.target.func_110124_au().toString());
        }
    }

    @Override
    public float[] getBlockBounds() {
        if (!this.dummy) {
            return null;
        }
        switch (this.facing) {
            case NORTH: {
                return new float[]{0.125f, 0.0625f, 0.125f, 0.875f, 0.875f, 1.0f};
            }
            case SOUTH: {
                return new float[]{0.125f, 0.0625f, 0.0f, 0.875f, 0.875f, 0.875f};
            }
            case WEST: {
                return new float[]{0.125f, 0.0625f, 0.125f, 1.0f, 0.875f, 0.875f};
            }
            case EAST: {
                return new float[]{0.0f, 0.0625f, 0.125f, 0.875f, 0.875f, 0.875f};
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderBB == null) {
            this.renderBB = new AxisAlignedBB(this.func_174877_v().func_177982_a(-8, -8, -8), this.func_174877_v().func_177982_a(8, 8, 8));
        }
        return this.renderBB;
    }

    @Override
    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        if (this.dummy) {
            TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            if (te instanceof TileEntityTurret) {
                return ((TileEntityTurret)te).hammerUseSide(side, player, hitX, hitY, hitZ);
            }
            return false;
        }
        if (player.func_70093_af()) {
            this.redstoneControlInverted = !this.redstoneControlInverted;
            ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.rsControl." + (this.redstoneControlInverted ? "invertedOn" : "invertedOff"), new Object[0])});
            this.func_70296_d();
            this.markContainingBlockForUpdate(null);
        }
        return true;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return NonNullList.func_191196_a();
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates(int slot) {
    }

    @Override
    public boolean canOpenGui(EntityPlayer player) {
        if (this.hasOwnerRights(player)) {
            return true;
        }
        ChatUtils.sendServerNoSpamMessages(player, new ITextComponent[]{new TextComponentTranslation("chat.immersiveengineering.info.notOwner", new Object[]{this.owner})});
        return false;
    }

    @Override
    public boolean canOpenGui() {
        return false;
    }

    @Override
    public int getGuiID() {
        return 13;
    }

    @Override
    public TileEntity getGuiMaster() {
        if (!this.dummy) {
            return this;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
        if (te instanceof TileEntityTurret) {
            return te;
        }
        return null;
    }

    @Override
    public EnumFacing getFacing() {
        return this.facing;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    @Override
    public int getFacingLimitation() {
        return 2;
    }

    @Override
    public boolean mirrorFacingOnPlacement(EntityLivingBase placer) {
        return false;
    }

    @Override
    public boolean canHammerRotate(EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase entity) {
        return false;
    }

    @Override
    public boolean canRotate(EnumFacing axis) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        TileEntity te;
        if (this.dummy && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) instanceof TileEntityTurret) {
            return ((TileEntityTurret)te).canEntityDestroy(entity);
        }
        if (entity instanceof EntityPlayer) {
            return this.hasOwnerRights((EntityPlayer)entity);
        }
        return true;
    }

    @Override
    public boolean isDummy() {
        return this.dummy;
    }

    @Override
    public void placeDummies(BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.field_145850_b.func_175656_a(pos.func_177984_a(), state);
        ((TileEntityTurret)this.field_145850_b.func_175625_s((BlockPos)pos.func_177984_a())).dummy = true;
        ((TileEntityTurret)this.field_145850_b.func_175625_s((BlockPos)pos.func_177984_a())).facing = this.facing;
    }

    @Override
    public void breakDummies(BlockPos pos, IBlockState state) {
        if (this.field_145850_b.func_175625_s(this.dummy ? this.func_174877_v().func_177977_b() : this.func_174877_v().func_177984_a()) instanceof TileEntityTurret) {
            this.field_145850_b.func_175698_g(this.dummy ? this.func_174877_v().func_177977_b() : this.func_174877_v().func_177984_a());
        }
    }

    @Override
    public ItemStack getTileDrop(EntityPlayer player, IBlockState state) {
        ItemStack stack = new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
        TileEntityTurret turret = this;
        if (this.dummy) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b());
            if (t instanceof TileEntityTurret) {
                turret = (TileEntityTurret)t;
            } else {
                return stack;
            }
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (!(turret.owner == null || player != null && player.func_70005_c_().equalsIgnoreCase(turret.owner))) {
            tag.func_74778_a("owner", turret.owner);
        }
        if (turret.targetList.size() != 1 || !this.isListedName(turret.targetList, turret.owner)) {
            NBTTagList list = new NBTTagList();
            for (String s : turret.targetList) {
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            tag.func_74782_a("targetList", (NBTBase)list);
        }
        if (turret.whitelist) {
            tag.func_74757_a("whitelist", turret.whitelist);
        }
        if (turret.attackAnimals) {
            tag.func_74757_a("attackAnimals", turret.attackAnimals);
        }
        if (!turret.attackPlayers) {
            tag.func_74757_a("attackPlayers", turret.attackPlayers);
        }
        if (turret.attackNeutrals) {
            tag.func_74757_a("attackNeutrals", turret.attackNeutrals);
        }
        if (turret.redstoneControlInverted) {
            tag.func_74757_a("redstoneControlInverted", turret.redstoneControlInverted);
        }
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    @Override
    public void readOnPlacement(@Nullable EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag.func_74764_b("owner")) {
                this.owner = tag.func_74779_i("owner");
            } else if (placer != null) {
                this.owner = placer.func_70005_c_();
            }
            if (tag.func_74764_b("targetList")) {
                NBTTagList list = tag.func_150295_c("targetList", 8);
                this.targetList.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    this.targetList.add(list.func_150307_f(i));
                }
            } else if (this.owner != null) {
                this.targetList.add(this.owner);
            }
            if (tag.func_74764_b("whitelist")) {
                this.whitelist = tag.func_74767_n("whitelist");
            }
            if (tag.func_74764_b("attackAnimals")) {
                this.attackAnimals = tag.func_74767_n("attackAnimals");
            }
            if (tag.func_74764_b("attackPlayers")) {
                this.attackPlayers = tag.func_74767_n("attackPlayers");
            }
            if (tag.func_74764_b("attackNeutrals")) {
                this.attackNeutrals = tag.func_74767_n("attackNeutrals");
            }
            if (tag.func_74764_b("redstoneControlInverted")) {
                this.redstoneControlInverted = tag.func_74767_n("redstoneControlInverted");
            }
        } else if (placer != null) {
            this.owner = placer.func_70005_c_();
            this.targetList.add(this.owner);
        }
    }

    @Override
    @Nonnull
    public FluxStorage getFluxStorage() {
        TileEntity te;
        if (this.dummy && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) instanceof TileEntityTurret) {
            return ((TileEntityTurret)te).getFluxStorage();
        }
        return this.energyStorage;
    }

    @Override
    @Nonnull
    public IEEnums.SideConfig getEnergySideConfig(EnumFacing facing) {
        return !this.dummy ? IEEnums.SideConfig.INPUT : IEEnums.SideConfig.NONE;
    }

    @Override
    public EnergyHelper.IEForgeEnergyWrapper getCapabilityWrapper(EnumFacing facing) {
        if (!this.dummy) {
            return this.wrappers[facing == null ? 0 : facing.ordinal()];
        }
        return null;
    }

    @Override
    public ArrayList<String> compileDisplayList() {
        return displayList;
    }
}

