/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.shader;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderEffectFunction;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderCaseBalloon;
import blusunrize.immersiveengineering.api.shader.ShaderCaseBanner;
import blusunrize.immersiveengineering.api.shader.ShaderCaseChemthrower;
import blusunrize.immersiveengineering.api.shader.ShaderCaseDrill;
import blusunrize.immersiveengineering.api.shader.ShaderCaseItem;
import blusunrize.immersiveengineering.api.shader.ShaderCaseMinecart;
import blusunrize.immersiveengineering.api.shader.ShaderCaseRailgun;
import blusunrize.immersiveengineering.api.shader.ShaderCaseRevolver;
import blusunrize.immersiveengineering.api.shader.ShaderCaseShield;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Triple;

public class ShaderRegistry {
    public static LinkedHashMap<String, ShaderRegistryEntry> shaderRegistry = new LinkedHashMap();
    public static ArrayList<String> chestLootShaders = new ArrayList();
    public static HashMap<EnumRarity, Integer> rarityWeightMap = new HashMap();
    public static ArrayList<EnumRarity> sortedRarityMap;
    public static ArrayListMultimap<String, String> receivedShaders;
    public static HashMap<EnumRarity, Integer> totalWeight;
    public static HashMap<String, HashMap<EnumRarity, Integer>> playerTotalWeight;
    public static IngredientStack defaultReplicationCost;
    public static HashMap<ResourceLocation, double[]> defaultLayerBounds;
    public static Set<IShaderRegistryMethod> shaderRegistrationMethods;
    public static ManualInstance.ManualEntry manualEntry;
    public static Item itemShader;
    public static Item itemShaderBag;
    public static List<ItemStack> itemExamples;

    public static ShaderCase getShader(String name, String shaderType) {
        if (shaderRegistry.containsKey(name)) {
            return shaderRegistry.get(name).getCase(shaderType);
        }
        return null;
    }

    public static ShaderRegistryEntry registerShader(String name, String overlayType, EnumRarity rarity, int colourPrimary, int colourSecondary, int colourBackground, int colourBlade, String additionalTexture, int colourAdditional, boolean loot, boolean bags) {
        ShaderRegistry.registerShader_Item(name, rarity, colourBackground, colourPrimary, colourSecondary);
        ShaderRegistry.registerShader_Revolver(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, colourBlade, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Chemthrower(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Drill(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Railgun(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Shield(name, overlayType, rarity, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Minecart(name, overlayType, rarity, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Balloon(name, overlayType, rarity, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        ShaderRegistry.registerShader_Banner(name, overlayType, rarity, colourPrimary, colourSecondary, additionalTexture, colourAdditional);
        for (IShaderRegistryMethod method : shaderRegistrationMethods) {
            method.apply(name, overlayType, rarity, colourBackground, colourPrimary, colourSecondary, colourBlade, additionalTexture, colourAdditional);
        }
        return shaderRegistry.get(name).setCrateLoot(loot).setBagLoot(bags).setReplicationCost(defaultReplicationCost.copyWithMultipliedSize(10 - rarityWeightMap.get(rarity)));
    }

    public static <T extends ShaderCase> T registerShaderCase(String name, T shader, EnumRarity rarity) {
        if (!shaderRegistry.containsKey(name)) {
            shaderRegistry.put(name, new ShaderRegistryEntry(name, rarity, shader));
        } else {
            shaderRegistry.get(name).addCase(shader);
        }
        return shader;
    }

    public static ShaderCaseItem registerShader_Item(String name, EnumRarity rarity, int colour0, int colour1, int colour2) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shader_0"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shader_1"), colour1));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shader_2"), colour2));
        ShaderCaseItem shader = new ShaderCaseItem(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseRevolver registerShader_Revolver(String name, String overlayType, EnumRarity rarity, int colour0, int colour1, int colour2, int colourBlade, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_grip"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_0"), colour1));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_0"), colourBlade));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? new ResourceLocation(additionalTexture) : new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_" + additionalTexture);
            list.add(new ShaderCase.ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:revolvers/shaders/revolver_uncoloured"), -1));
        ShaderCaseRevolver shader = new ShaderCaseRevolver(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseChemthrower registerShader_Chemthrower(String name, String overlayType, EnumRarity rarity, int colour0, int colour1, int colour2, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/chemthrower_0"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/chemthrower_0"), colour1));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/chemthrower_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? new ResourceLocation(additionalTexture) : new ResourceLocation("immersiveengineering:items/shaders/chemthrower_" + additionalTexture);
            list.add(new ShaderCase.ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/chemthrower_uncoloured"), -1));
        ShaderCaseChemthrower shader = new ShaderCaseChemthrower(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseDrill registerShader_Drill(String name, String overlayType, EnumRarity rarity, int colour0, int colour1, int colour2, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/drill_diesel_0"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/drill_diesel_0"), colour1));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/drill_diesel_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? new ResourceLocation(additionalTexture) : new ResourceLocation("immersiveengineering:items/shaders/drill_diesel_" + additionalTexture);
            list.add(new ShaderCase.ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/drill_diesel_uncoloured"), -1));
        list.add(new ShaderCase.ShaderLayer(null, -1));
        ShaderCaseDrill shader = new ShaderCaseDrill(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseRailgun registerShader_Railgun(String name, String overlayType, EnumRarity rarity, int colour0, int colour1, int colour2, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/railgun_0"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/railgun_0"), colour1));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/railgun_1_" + overlayType), colour2));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? new ResourceLocation(additionalTexture) : new ResourceLocation("immersiveengineering:items/shaders/railgun_" + additionalTexture);
            list.add(new ShaderCase.ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/railgun_uncoloured"), -1));
        ShaderCaseRailgun shader = new ShaderCaseRailgun(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseShield registerShader_Shield(String name, String overlayType, EnumRarity rarity, int colour0, int colour1, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/shield_0"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/shield_1_" + overlayType), colour1));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? new ResourceLocation(additionalTexture) : new ResourceLocation("immersiveengineering:items/shaders/shield_" + additionalTexture);
            list.add(new ShaderCase.ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:items/shaders/shield_uncoloured"), -1));
        ShaderCaseShield shader = new ShaderCaseShield(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseMinecart registerShader_Minecart(String name, String overlayType, EnumRarity rarity, int colour0, int colour1, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:textures/models/shaders/minecart_0.png"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:textures/models/shaders/minecart_1_" + overlayType + ".png"), colour1));
        if (additionalTexture != null) {
            if (additionalTexture.indexOf(58) >= 0) {
                list.add(new ShaderCase.ShaderLayer(new ResourceLocation(additionalTexture + ".png"), colourAddtional));
            } else {
                list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:textures/models/shaders/minecart_" + additionalTexture + ".png"), colourAddtional));
            }
        }
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:textures/models/shaders/minecart_uncoloured.png"), -1));
        ShaderCaseMinecart shader = new ShaderCaseMinecart(list);
        if (overlayType.equals("1") || overlayType.equals("2") || overlayType.equals("7")) {
            shader.renderSides[1][1] = false;
            shader.renderSides[1][2] = false;
        }
        if (additionalTexture != null) {
            shader.renderSides[2][1] = false;
            shader.renderSides[2][2] = false;
        }
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseBalloon registerShader_Balloon(String name, String overlayType, EnumRarity rarity, int colour0, int colour1, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/balloon_0"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/balloon_1_" + overlayType), colour1));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? new ResourceLocation(additionalTexture) : new ResourceLocation("immersiveengineering:blocks/shaders/balloon_" + additionalTexture);
            list.add(new ShaderCase.ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/balloon_uncoloured"), -1));
        ShaderCaseBalloon shader = new ShaderCaseBalloon(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static ShaderCaseBanner registerShader_Banner(String name, String overlayType, EnumRarity rarity, int colour0, int colour1, String additionalTexture, int colourAddtional) {
        ArrayList<ShaderCase.ShaderLayer> list = new ArrayList<ShaderCase.ShaderLayer>();
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/banner_0"), colour0));
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/banner_1_" + overlayType), colour1));
        if (additionalTexture != null) {
            ResourceLocation rl = additionalTexture.indexOf(58) >= 0 ? new ResourceLocation(additionalTexture) : new ResourceLocation("immersiveengineering:blocks/shaders/banner_" + additionalTexture);
            list.add(new ShaderCase.ShaderLayer(rl, colourAddtional));
        }
        list.add(new ShaderCase.ShaderLayer(new ResourceLocation("immersiveengineering:blocks/shaders/banner_uncoloured"), -1));
        ShaderCaseBanner shader = new ShaderCaseBanner(list);
        return ShaderRegistry.registerShaderCase(name, shader, rarity);
    }

    public static void addRegistrationMethod(IShaderRegistryMethod method) {
        shaderRegistrationMethods.add(method);
    }

    public static void compileWeight() {
        int i;
        totalWeight.clear();
        chestLootShaders.clear();
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (entry.getIsBagLoot()) {
                int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
                for (Map.Entry<EnumRarity, Integer> weightedRarity : rarityWeightMap.entrySet()) {
                    if (!(entry.getIsInLowerBags() ? weightedRarity.getValue() >= entryRarityWeight : weightedRarity.getValue() == entryRarityWeight)) continue;
                    int i2 = totalWeight.containsKey(weightedRarity.getKey()) ? totalWeight.get(weightedRarity.getKey()) : 0;
                    totalWeight.put(weightedRarity.getKey(), i2 + entry.getWeight());
                }
            }
            if (!entry.getIsCrateLoot()) continue;
            for (i = 0; i < entry.getWeight(); ++i) {
                chestLootShaders.add(entry.getName());
            }
        }
        sortedRarityMap.clear();
        sortedRarityMap.addAll(rarityWeightMap.keySet());
        Collections.sort(sortedRarityMap, new Comparator<EnumRarity>(){

            @Override
            public int compare(EnumRarity enum0, EnumRarity enum1) {
                return Integer.compare(rarityWeightMap.get(enum0), rarityWeightMap.get(enum1));
            }
        });
        if (manualEntry != null) {
            ArrayList<ManualPages.PositionedItemStack[]> recipes = new ArrayList<ManualPages.PositionedItemStack[]>();
            NonNullList shaderBags = NonNullList.func_191197_a((int)sortedRarityMap.size(), (Object)ItemStack.field_190927_a);
            recipes = new ArrayList();
            for (i = 0; i < sortedRarityMap.size(); ++i) {
                EnumRarity outputRarity = sortedRarityMap.get(i);
                shaderBags.set(i, (Object)new ItemStack(itemShaderBag));
                ((ItemStack)shaderBags.get(i)).func_77982_d(new NBTTagCompound());
                ((ItemStack)shaderBags.get(i)).func_77978_p().func_74778_a("rarity", outputRarity.toString());
                ArrayList<EnumRarity> upperRarities = ShaderRegistry.getHigherRarities(outputRarity);
                if (upperRarities.isEmpty()) continue;
                ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
                for (EnumRarity r : upperRarities) {
                    ItemStack bag = new ItemStack(itemShaderBag);
                    bag.func_77982_d(new NBTTagCompound());
                    bag.func_77978_p().func_74778_a("rarity", r.toString());
                    inputList.add(bag);
                }
                ItemStack s0 = new ItemStack(itemShaderBag, 2);
                s0.func_77982_d(new NBTTagCompound());
                s0.func_77978_p().func_74778_a("rarity", outputRarity.toString());
                if (inputList.isEmpty()) continue;
                recipes.add(new ManualPages.PositionedItemStack[]{new ManualPages.PositionedItemStack(inputList, 33, 0), new ManualPages.PositionedItemStack(s0, 69, 0)});
            }
            ShaderRegistry.manualEntry.getPages()[2] = new ManualPages.ItemDisplay(ManualHelper.getManual(), "shader2", (NonNullList<ItemStack>)shaderBags);
            ShaderRegistry.manualEntry.getPages()[3] = new ManualPages.CraftingMulti(ManualHelper.getManual(), "shader3", recipes.toArray((T[])new ManualPages.PositionedItemStack[recipes.size()][3]));
        }
    }

    public static void recalculatePlayerTotalWeight(String player) {
        if (!playerTotalWeight.containsKey(player)) {
            playerTotalWeight.put(player, new HashMap());
        } else {
            playerTotalWeight.get(player).clear();
        }
        List received = receivedShaders.get((Object)player);
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (!entry.getIsBagLoot()) continue;
            int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
            for (Map.Entry<EnumRarity, Integer> weightedRarity : rarityWeightMap.entrySet()) {
                if (!(entry.getIsInLowerBags() ? weightedRarity.getValue() >= entryRarityWeight : weightedRarity.getValue() == entryRarityWeight)) continue;
                int weight = playerTotalWeight.get(player).containsKey(weightedRarity.getKey()) ? playerTotalWeight.get(player).get(weightedRarity.getKey()) : 0;
                int value = entry.getWeight();
                if (received.contains(entry.getName())) {
                    value = 1;
                }
                playerTotalWeight.get(player).put(weightedRarity.getKey(), weight + value);
            }
        }
    }

    public static String getRandomShader(String player, Random rand, EnumRarity minRarity, boolean addToReceived) {
        int total = 0;
        if (!playerTotalWeight.containsKey(player)) {
            playerTotalWeight.put(player, totalWeight);
        }
        total = playerTotalWeight.get(player).get(minRarity);
        String shader = null;
        int minWeight = rarityWeightMap.get(minRarity);
        int weight = total < 1 ? total : rand.nextInt(total);
        for (ShaderRegistryEntry entry : shaderRegistry.values()) {
            if (!entry.getIsBagLoot()) continue;
            int entryRarityWeight = rarityWeightMap.get(entry.getRarity());
            if (!(entry.getIsInLowerBags() ? minWeight >= entryRarityWeight : minWeight == entryRarityWeight)) continue;
            int value = entry.getWeight();
            if (receivedShaders.get((Object)player).contains(entry.getName())) {
                value = 1;
            }
            if ((weight -= value) > 0) continue;
            shader = entry.getName();
            break;
        }
        if (addToReceived) {
            if (!receivedShaders.get((Object)player).contains(shader)) {
                receivedShaders.put((Object)player, shader);
            }
            ShaderRegistry.recalculatePlayerTotalWeight(player);
        }
        return shader;
    }

    public static EnumRarity getLowerRarity(EnumRarity rarity) {
        int idx = sortedRarityMap.indexOf(rarity);
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx + 1; next < sortedRarityMap.size(); ++next) {
            if (rarityWeightMap.get(sortedRarityMap.get(next)) <= weight) continue;
            return sortedRarityMap.get(next);
        }
        return null;
    }

    public static ArrayList<EnumRarity> getAllLowerRarities(EnumRarity rarity) {
        ArrayList<EnumRarity> list = new ArrayList<EnumRarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx + 1; next < sortedRarityMap.size(); ++next) {
            if (rarityWeightMap.get(sortedRarityMap.get(next)) <= weight) continue;
            list.add(sortedRarityMap.get(next));
        }
        return list;
    }

    public static ArrayList<EnumRarity> getHigherRarities(EnumRarity rarity) {
        ArrayList<EnumRarity> list = new ArrayList<EnumRarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        if (idx <= 0) {
            return list;
        }
        int weight = rarityWeightMap.get(rarity);
        int lowerWeight = -1;
        for (int next = idx - 1; next >= 0; --next) {
            EnumRarity r = sortedRarityMap.get(next);
            int rWeight = rarityWeightMap.get(r);
            if (rWeight >= weight || lowerWeight != -1 && rWeight < lowerWeight) continue;
            list.add(r);
            lowerWeight = rWeight;
        }
        return list;
    }

    public static ArrayList<EnumRarity> getAllHigherRarities(EnumRarity rarity) {
        ArrayList<EnumRarity> list = new ArrayList<EnumRarity>();
        int idx = sortedRarityMap.indexOf(rarity);
        if (idx <= 0) {
            return list;
        }
        int weight = rarityWeightMap.get(rarity);
        for (int next = idx - 1; next >= 0; --next) {
            EnumRarity r = sortedRarityMap.get(next);
            int rWeight = rarityWeightMap.get(r);
            if (rWeight >= weight) continue;
            list.add(r);
        }
        return list;
    }

    public static Triple<ItemStack, ShaderRegistryEntry, ShaderCase> getStoredShaderAndCase(ItemStack itemStack) {
        CapabilityShader.ShaderWrapper wrapper;
        if (!itemStack.func_190926_b() && itemStack.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && (wrapper = (CapabilityShader.ShaderWrapper)itemStack.getCapability(CapabilityShader.SHADER_CAPABILITY, null)) != null) {
            return ShaderRegistry.getStoredShaderAndCase(wrapper);
        }
        return null;
    }

    public static Triple<ItemStack, ShaderRegistryEntry, ShaderCase> getStoredShaderAndCase(CapabilityShader.ShaderWrapper wrapper) {
        IShaderItem iShaderItem;
        ShaderRegistryEntry registryEntry;
        ItemStack shader = wrapper.getShaderItem();
        if (!shader.func_190926_b() && shader.func_77973_b() instanceof IShaderItem && (registryEntry = shaderRegistry.get((iShaderItem = (IShaderItem)shader.func_77973_b()).getShaderName(shader))) != null) {
            return Triple.of((Object)shader, (Object)registryEntry, (Object)registryEntry.getCase(wrapper.getShaderType()));
        }
        return null;
    }

    static {
        rarityWeightMap.put(EnumRarity.COMMON, 9);
        rarityWeightMap.put(EnumRarity.UNCOMMON, 7);
        rarityWeightMap.put(EnumRarity.RARE, 5);
        rarityWeightMap.put(EnumRarity.EPIC, 3);
        rarityWeightMap.put(Lib.RARITY_Masterwork, 1);
        sortedRarityMap = new ArrayList();
        receivedShaders = ArrayListMultimap.create();
        totalWeight = new HashMap();
        playerTotalWeight = new HashMap();
        defaultReplicationCost = new IngredientStack("dustSilver");
        defaultLayerBounds = new HashMap();
        shaderRegistrationMethods = new HashSet<IShaderRegistryMethod>();
        itemExamples = new ArrayList<ItemStack>();
    }

    public static class ShaderRegistryEntry {
        public String name;
        public HashMap<String, ShaderCase> cases = new HashMap();
        public EnumRarity rarity;
        public int weight;
        public boolean isCrateLoot;
        public boolean isBagLoot;
        public boolean isInLowerBags = true;
        public String info_set;
        public String info_reference;
        public String info_details;
        public IngredientStack replicationCost;
        public IShaderEffectFunction effectFunction;
        private static final IShaderEffectFunction DEFAULT_EFFECT = (world, shader, item, shaderType, pos, dir, scale) -> {};

        public ShaderRegistryEntry(String name, EnumRarity rarity, List<ShaderCase> cases) {
            this.name = name;
            this.rarity = rarity;
            this.weight = rarityWeightMap.get(rarity);
            for (ShaderCase sCase : cases) {
                this.cases.put(sCase.getShaderType(), sCase);
            }
        }

        public ShaderRegistryEntry(String name, EnumRarity rarity, ShaderCase ... cases) {
            this(name, rarity, Arrays.asList(cases));
        }

        public ShaderRegistryEntry addCase(String type, ShaderCase sCase) {
            this.cases.put(type, sCase);
            return this;
        }

        public ShaderRegistryEntry addCase(ShaderCase sCase) {
            return this.addCase(sCase.getShaderType(), sCase);
        }

        public ShaderCase getCase(String type) {
            return this.cases.get(type);
        }

        public List<ShaderCase> getCases() {
            return new ArrayList<ShaderCase>(this.cases.values());
        }

        public String getName() {
            return this.name;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public ShaderRegistryEntry setWeight(int weight) {
            this.weight = weight;
            return this;
        }

        public int getWeight() {
            return this.weight;
        }

        public ShaderRegistryEntry setCrateLoot(boolean b) {
            this.isCrateLoot = b;
            return this;
        }

        public boolean getIsCrateLoot() {
            return this.isCrateLoot;
        }

        public ShaderRegistryEntry setBagLoot(boolean b) {
            this.isBagLoot = b;
            return this;
        }

        public boolean getIsBagLoot() {
            return this.isBagLoot;
        }

        public ShaderRegistryEntry setInLowerBags(boolean b) {
            this.isInLowerBags = b;
            return this;
        }

        public boolean getIsInLowerBags() {
            return this.isInLowerBags;
        }

        public ShaderRegistryEntry setInfo(@Nullable String set, @Nullable String reference, @Nullable String details) {
            this.info_set = set;
            this.info_reference = reference;
            this.info_details = details;
            return this;
        }

        public ShaderRegistryEntry setReplicationCost(@Nonnull IngredientStack replicationCost) {
            this.replicationCost = replicationCost;
            return this;
        }

        public ShaderRegistryEntry setEffectFunction(@Nonnull IShaderEffectFunction effectFunction) {
            this.effectFunction = effectFunction;
            return this;
        }

        @Nonnull
        public IShaderEffectFunction getEffectFunction() {
            if (this.effectFunction != null) {
                return this.effectFunction;
            }
            return DEFAULT_EFFECT;
        }
    }

    public static interface IShaderRegistryMethod<T extends ShaderCase> {
        public T apply(String var1, String var2, EnumRarity var3, int var4, int var5, int var6, int var7, String var8, int var9);
    }
}

