/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.common.book.Book;

public class Word {
    private final Book book;
    private final GuiBook gui;
    private final FontRenderer font;
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final String text;
    private final int color;
    private final String codes;
    private final List<Word> linkCluster;
    private final String tooltip;
    private final Runnable onClick;

    public Word(GuiBook gui, Span span, String text, int x, int y, int strWidth, List<Word> cluster) {
        this.book = gui.book;
        this.gui = gui;
        this.font = span.font;
        this.x = x;
        this.y = y;
        this.width = strWidth;
        this.height = 8;
        this.text = text;
        this.color = span.color;
        this.codes = span.codes;
        this.onClick = span.onClick;
        this.linkCluster = cluster;
        this.tooltip = span.tooltip;
    }

    public void render(int mouseX, int mouseY) {
        String renderTarget = this.codes + this.text;
        int renderColor = this.color;
        if (this.isClusterHovered(mouseX, mouseY)) {
            if (this.onClick != null) {
                renderColor = this.book.linkHoverColor;
            }
            if (!this.tooltip.isEmpty()) {
                this.gui.setTooltip(this.tooltip);
            }
        }
        this.font.func_78276_b(renderTarget, this.x, this.y, renderColor);
    }

    public void click(int mouseX, int mouseY, int mouseButton) {
        if (this.onClick != null && mouseButton == 0 && this.isHovered(mouseX, mouseY)) {
            this.onClick.run();
        }
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return this.gui.isMouseInRelativeRange(mouseX, mouseY, this.x, this.y, this.width, this.height);
    }

    private boolean isClusterHovered(int mouseX, int mouseY) {
        if (this.linkCluster == null) {
            return this.isHovered(mouseX, mouseY);
        }
        for (Word w : this.linkCluster) {
            if (!w.isHovered(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }
}

