/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.gui;

import java.awt.Color;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;
import vazkii.patchouli.api.BookDrawScreenEvent;
import vazkii.patchouli.client.base.ClientTicker;
import vazkii.patchouli.client.base.PersistentData;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.EntryDisplayState;
import vazkii.patchouli.client.book.gui.GuiBookEntry;
import vazkii.patchouli.client.book.gui.GuiBookLanding;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookArrow;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBack;
import vazkii.patchouli.client.book.gui.button.GuiButtonBookBookmark;
import vazkii.patchouli.client.handler.MultiblockVisualizationHandler;
import vazkii.patchouli.common.base.PatchouliConfig;
import vazkii.patchouli.common.base.PatchouliSounds;
import vazkii.patchouli.common.book.Book;

public abstract class GuiBook
extends GuiScreen {
    public static final int FULL_WIDTH = 272;
    public static final int FULL_HEIGHT = 180;
    public static final int PAGE_WIDTH = 116;
    public static final int PAGE_HEIGHT = 156;
    public static final int TOP_PADDING = 18;
    public static final int LEFT_PAGE_X = 15;
    public static final int RIGHT_PAGE_X = 141;
    public static final int TEXT_LINE_HEIGHT = 9;
    public static final int MAX_BOOKMARKS = 10;
    public final Book book;
    private static int lastSound;
    public int bookLeft;
    public int bookTop;
    private List<String> tooltip;
    private ItemStack tooltipStack;
    private Pair<BookEntry, Integer> targetPage;
    protected int page = 0;
    protected int maxpages = 0;
    public int ticksInBook;
    public int maxScale;
    boolean needsBookmarkUpdate = false;

    public GuiBook(Book book) {
        this.book = book;
    }

    public void func_73866_w_() {
        int guiScale = this.field_146297_k.field_71474_y.field_74335_Z;
        this.maxScale = this.getMaxAllowedScale();
        int persistentScale = Math.min(PersistentData.data.bookGuiScale, this.maxScale);
        if (persistentScale > 0 && persistentScale != guiScale) {
            this.field_146297_k.field_71474_y.field_74335_Z = persistentScale;
            ScaledResolution res = new ScaledResolution(this.field_146297_k);
            this.field_146294_l = res.func_78326_a();
            this.field_146295_m = res.func_78328_b();
            this.field_146297_k.field_71474_y.field_74335_Z = guiScale;
        }
        this.bookLeft = this.field_146294_l / 2 - 136;
        this.bookTop = this.field_146295_m / 2 - 90;
        this.book.contents.currentGui = this;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButtonBookBack(this, this.field_146294_l / 2 - 9, this.bookTop + 180 - 5));
        this.field_146292_n.add(new GuiButtonBookArrow(this, this.bookLeft - 4, this.bookTop + 180 - 6, true));
        this.field_146292_n.add(new GuiButtonBookArrow(this, this.bookLeft + 272 - 14, this.bookTop + 180 - 6, false));
        this.addBookmarkButtons();
    }

    public final void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        int guiScale = this.field_146297_k.field_71474_y.field_74335_Z;
        GlStateManager.func_179094_E();
        int persistentScale = Math.min(PersistentData.data.bookGuiScale, this.maxScale);
        if (persistentScale > 0 && persistentScale != guiScale) {
            this.field_146297_k.field_71474_y.field_74335_Z = persistentScale;
            float s = (float)persistentScale / (float)res.func_78325_e();
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            res = new ScaledResolution(this.field_146297_k);
            int sw = res.func_78326_a();
            int sh = res.func_78328_b();
            mouseX = Mouse.getX() * sw / this.field_146297_k.field_71443_c;
            mouseY = sh - Mouse.getY() * sh / this.field_146297_k.field_71440_d - 1;
        }
        this.drawScreenAfterScale(mouseX, mouseY, partialTicks);
        this.field_146297_k.field_71474_y.field_74335_Z = guiScale;
        GlStateManager.func_179121_F();
    }

    final void drawScreenAfterScale(int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.func_146276_q_();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.bookLeft, (float)this.bookTop, (float)0.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.drawBackgroundElements(mouseX, mouseY, partialTicks);
        this.drawForegroundElements(mouseX, mouseY, partialTicks);
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)new BookDrawScreenEvent(this, this.book.resourceLoc, mouseX, mouseY, partialTicks));
        this.drawTooltip(mouseX, mouseY);
    }

    public void addBookmarkButtons() {
        this.field_146292_n.removeIf(b -> b instanceof GuiButtonBookBookmark);
        int y = 0;
        List<PersistentData.DataHolder.BookData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
        for (int i = 0; i < bookmarks.size(); ++i) {
            PersistentData.DataHolder.BookData.Bookmark bookmark = bookmarks.get(i);
            this.field_146292_n.add(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, bookmark));
            y += 12;
        }
        y += y == 0 ? 0 : 2;
        if (this.shouldAddAddBookmarkButton() && bookmarks.size() <= 10) {
            this.field_146292_n.add(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + y, null));
        }
        if (MultiblockVisualizationHandler.hasMultiblock && MultiblockVisualizationHandler.bookmark != null) {
            this.field_146292_n.add(new GuiButtonBookBookmark(this, this.bookLeft + 272, this.bookTop + 18 + 156 - 20, MultiblockVisualizationHandler.bookmark, true));
        }
    }

    protected boolean shouldAddAddBookmarkButton() {
        return false;
    }

    public void bookmarkThis() {
    }

    public void onFirstOpened() {
    }

    public void func_73876_c() {
        if (!GuiBook.func_146272_n()) {
            ++this.ticksInBook;
        }
        if (this.needsBookmarkUpdate) {
            this.needsBookmarkUpdate = false;
            this.addBookmarkButtons();
        }
    }

    final void drawBackgroundElements(int mouseX, int mouseY, float partialTicks) {
        GuiBook.drawFromTexture(this.book, 0, 0, 0, 0, 272, 180);
    }

    void drawForegroundElements(int mouseX, int mouseY, float partialTicks) {
    }

    final void drawTooltip(int mouseX, int mouseY) {
        if (this.tooltipStack != null) {
            List tooltip = this.func_191927_a(this.tooltipStack);
            Pair<BookEntry, Integer> provider = this.book.contents.getEntryForStack(this.tooltipStack);
            if (!(provider == null || this instanceof GuiBookEntry && ((GuiBookEntry)this).entry == provider.getLeft())) {
                tooltip.add(TextFormatting.GOLD + "(" + I18n.func_135052_a((String)"patchouli.gui.lexicon.shift_for_recipe", (Object[])new Object[0]) + ')');
                this.targetPage = provider;
            }
            GuiUtils.preItemToolTip((ItemStack)this.tooltipStack);
            FontRenderer font = this.tooltipStack.func_77973_b().getFontRenderer(this.tooltipStack);
            this.drawHoveringText(tooltip, mouseX, mouseY, font == null ? this.field_146289_q : font);
            GuiUtils.postItemToolTip();
        } else if (this.tooltip != null && !this.tooltip.isEmpty()) {
            ArrayList wrappedTooltip = new ArrayList();
            for (String s : this.tooltip) {
                Collections.addAll(wrappedTooltip, s.split("\n"));
            }
            GuiUtils.drawHoveringText(wrappedTooltip, (int)mouseX, (int)mouseY, (int)this.field_146294_l, (int)this.field_146295_m, (int)-1, (FontRenderer)this.field_146289_q);
        }
    }

    final void resetTooltip() {
        this.tooltipStack = null;
        this.tooltip = null;
        this.targetPage = null;
    }

    public static void drawFromTexture(Book book, int x, int y, int u, int v, int w, int h) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(book.bookResource);
        GuiBook.func_146110_a((int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (float)512.0f, (float)256.0f);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiButtonBookBack) {
            this.back(false);
        } else if (button instanceof GuiButtonBookArrow) {
            this.changePage(((GuiButtonBookArrow)button).left, false);
        } else if (button instanceof GuiButtonBookBookmark) {
            GuiButtonBookBookmark bookmarkButton = (GuiButtonBookBookmark)button;
            PersistentData.DataHolder.BookData.Bookmark bookmark = bookmarkButton.bookmark;
            if (bookmark == null || bookmark.getEntry(this.book) == null) {
                this.bookmarkThis();
            } else if (GuiBook.func_146272_n() && !bookmarkButton.multiblock) {
                List<PersistentData.DataHolder.BookData.Bookmark> bookmarks = PersistentData.data.getBookData((Book)this.book).bookmarks;
                bookmarks.remove(bookmark);
                PersistentData.save();
                this.needsBookmarkUpdate = true;
            } else {
                this.displayLexiconGui(new GuiBookEntry(this.book, bookmark.getEntry(this.book), bookmark.page), true);
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        switch (mouseButton) {
            case 0: {
                if (this.targetPage == null || !GuiBook.func_146272_n()) break;
                this.displayLexiconGui(new GuiBookEntry(this.book, (BookEntry)this.targetPage.getLeft(), (Integer)this.targetPage.getRight()), true);
                GuiBook.playBookFlipSound(this.book);
                break;
            }
            case 1: {
                this.back(true);
                break;
            }
            case 3: {
                this.changePage(true, true);
                break;
            }
            case 4: {
                this.changePage(false, true);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int w = Mouse.getEventDWheel();
        if (w < 0) {
            this.changePage(false, true);
        } else if (w > 0) {
            this.changePage(true, true);
        }
    }

    void back(boolean sfx) {
        if (!this.book.contents.guiStack.isEmpty()) {
            if (GuiBook.func_146272_n()) {
                this.displayLexiconGui(new GuiBookLanding(this.book), false);
                this.book.contents.guiStack.clear();
            } else {
                this.displayLexiconGui(this.book.contents.guiStack.pop(), false);
            }
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void changePage(boolean left, boolean sfx) {
        if (this.canSeePageButton(left)) {
            int oldpage = this.page--;
            if (!left) {
                ++this.page;
            }
            this.onPageChanged();
            if (sfx) {
                GuiBook.playBookFlipSound(this.book);
            }
        }
    }

    void onPageChanged() {
    }

    public boolean canBeOpened() {
        return true;
    }

    public boolean canSeePageButton(boolean left) {
        return left ? this.page > 0 : this.page + 1 < this.maxpages;
    }

    public boolean canSeeBackButton() {
        return !this.book.contents.guiStack.isEmpty();
    }

    public void setTooltip(String ... strings) {
        this.setTooltip(Arrays.asList(strings));
    }

    public void setTooltip(List<String> strings) {
        this.tooltip = strings;
    }

    public void setTooltipStack(ItemStack stack) {
        this.setTooltip(new String[0]);
        this.tooltipStack = stack;
    }

    public boolean isMouseInRelativeRange(int absMx, int absMy, int x, int y, int w, int h) {
        int mx = absMx - this.bookLeft;
        int my = absMy - this.bookTop;
        return mx > x && my > y && mx <= x + w && my <= y + h;
    }

    public void drawProgressBar(Book book, int mouseX, int mouseY, Predicate<BookEntry> filter) {
        if (!book.showProgress || PatchouliConfig.disableAdvancementLocking) {
            return;
        }
        int barLeft = 19;
        int barTop = 144;
        int barWidth = 106;
        int barHeight = 12;
        int totalEntries = 0;
        int unlockedEntries = 0;
        int unlockedSecretEntries = 0;
        for (BookEntry entry : book.contents.entries.values()) {
            if (!filter.test(entry)) continue;
            if (entry.isSecret()) {
                if (entry.isLocked()) continue;
                ++unlockedSecretEntries;
                continue;
            }
            BookCategory category = entry.getCategory();
            if (category.isSecret() && !category.isLocked()) continue;
            ++totalEntries;
            if (entry.isLocked()) continue;
            ++unlockedEntries;
        }
        float unlockFract = (float)unlockedEntries / Math.max(1.0f, (float)totalEntries);
        int progressWidth = (int)(((float)barWidth - 1.0f) * unlockFract);
        GuiBook.func_73734_a((int)barLeft, (int)barTop, (int)(barLeft + barWidth), (int)(barTop + barHeight), (int)book.headerColor);
        this.drawGradient(barLeft + 1, barTop + 1, barLeft + barWidth - 1, barTop + barHeight - 1, book.progressBarBackground);
        this.drawGradient(barLeft + 1, barTop + 1, barLeft + progressWidth, barTop + barHeight - 1, book.progressBarColor);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_meter", (Object[])new Object[0]), barLeft, barTop - 9, book.headerColor);
        if (this.isMouseInRelativeRange(mouseX, mouseY, barLeft, barTop, barWidth, barHeight)) {
            ArrayList<String> tooltip = new ArrayList<String>();
            String progressStr = I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_tooltip", (Object[])new Object[]{unlockedEntries, totalEntries});
            tooltip.add(progressStr);
            if (unlockedSecretEntries > 0) {
                if (unlockedSecretEntries == 1) {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_tooltip.secret1", (Object[])new Object[0]));
                } else {
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_tooltip.secret", (Object[])new Object[]{unlockedSecretEntries}));
                }
            }
            if (unlockedEntries != totalEntries) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"patchouli.gui.lexicon.progress_tooltip.info", (Object[])new Object[0]));
            }
            this.setTooltip(tooltip);
        }
    }

    private void drawGradient(int x, int y, int w, int h, int color) {
        int darkerColor = new Color(color).darker().getRGB();
        this.func_73733_a(x, y, w, h, color, darkerColor);
    }

    public void drawCenteredStringNoShadow(String s, int x, int y, int color) {
        this.field_146289_q.func_78276_b(s, x - this.field_146289_q.func_78256_a(s) / 2, y, color);
    }

    int getMaxAllowedScale() {
        Minecraft mc = Minecraft.func_71410_x();
        int scale = mc.field_71474_y.field_74335_Z;
        mc.field_71474_y.field_74335_Z = 0;
        ScaledResolution res = new ScaledResolution(mc);
        mc.field_71474_y.field_74335_Z = scale;
        return res.func_78325_e();
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    public int getPage() {
        return this.page;
    }

    public static void drawSeparator(Book book, int x, int y) {
        int w = 110;
        int h = 3;
        int rx = x + 58 - w / 2;
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GuiBook.drawFromTexture(book, rx, y, 140, 180, w, h);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawLock(Book book, int x, int y) {
        GuiBook.drawFromTexture(book, x, y, 250, 180, 16, 16);
    }

    public static void drawMarking(Book book, int x, int y, int rand, EntryDisplayState state) {
        if (!state.hasIcon) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        float alpha = state.hasAnimation ? (float)Math.sin(ClientTicker.total * 0.2f) * 0.3f + 0.7f : 1.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiBook.drawFromTexture(book, x, y, state.u, 197, 8, 8);
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawPageFiller(Book book) {
        GuiBook.drawPageFiller(book, 141, 18);
    }

    public static void drawPageFiller(Book book, int x, int y) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(book.fillerResource);
        GuiBook.func_146110_a((int)(x + 58 - 64), (int)(y + 78 - 74), (float)0.0f, (float)0.0f, (int)128, (int)128, (float)128.0f, (float)128.0f);
    }

    public static void playBookFlipSound(Book book) {
        if (ClientTicker.ticksInGame - lastSound > 6) {
            SoundEvent sfx = PatchouliSounds.getSound(book.flipSound, PatchouliSounds.book_flip);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)sfx, (float)((float)(0.7 + Math.random() * 0.3))));
            lastSound = ClientTicker.ticksInGame;
        }
    }

    public static void openWebLink(String address) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, new URI(address));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void displayLexiconGui(GuiBook gui, boolean push) {
        this.book.contents.openLexiconGui(gui, push);
    }
}

