/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.natives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionCallVirtual;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeFunctionCallable;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.StringUtil;
import stanhebben.zenscript.util.ZenPosition;

public class ZenNativeMember {
    private final List<IJavaMethod> methods = new ArrayList<IJavaMethod>();
    private IJavaMethod getter;
    private IJavaMethod setter;

    public IJavaMethod getGetter() {
        return this.getter;
    }

    public void setGetter(IJavaMethod getter) {
        if (this.getter != null) {
            throw new RuntimeException("already has a getter");
        }
        this.getter = getter;
    }

    public IJavaMethod getSetter() {
        return this.setter;
    }

    public void setSetter(IJavaMethod setter) {
        if (this.setter != null) {
            throw new RuntimeException("already has a setter");
        }
        this.setter = setter;
    }

    public IPartialExpression instance(ZenPosition position, IEnvironmentGlobal environment, IPartialExpression value) {
        return new InstanceGetValue(position, value);
    }

    public IPartialExpression instance(ZenPosition position, IEnvironmentGlobal environment) {
        return new StaticGetValue(position);
    }

    public void addMethod(IJavaMethod method) {
        this.methods.add(method);
    }

    public List<IJavaMethod> getMethods() {
        return this.methods;
    }

    public String toString() {
        return Arrays.toString(this.methods.toArray());
    }

    private class StaticSymbol
    implements IZenSymbol {
        private StaticSymbol() {
        }

        @Override
        public IPartialExpression instance(ZenPosition position) {
            return new StaticGetValue(position);
        }
    }

    public class StaticGetValue
    implements IPartialExpression {
        private final ZenPosition position;

        private StaticGetValue(ZenPosition position) {
            this.position = position;
        }

        @Override
        public Expression eval(IEnvironmentGlobal environment) {
            if (ZenNativeMember.this.getter == null) {
                throw new RuntimeException("No Getter found!");
            }
            return new ExpressionCallStatic(this.position, environment, ZenNativeMember.this.getter, new Expression[0]);
        }

        @Override
        public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
            if (ZenNativeMember.this.setter == null) {
                throw new RuntimeException("No Setter found!");
            }
            return new ExpressionCallStatic(position, environment, ZenNativeMember.this.setter, other);
        }

        @Override
        public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
            ZenType type = this.getType();
            if (type == null) {
                environment.error(position, "No such member: " + name);
                return new ExpressionInvalid(position);
            }
            return type.getMember(position, environment, this, name);
        }

        @Override
        public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
            IJavaMethod method = JavaMethod.select(true, ZenNativeMember.this.methods, environment, values);
            if (method == null) {
                if (ZenNativeMember.this.getter != null && this.getType() instanceof ZenTypeFunctionCallable) {
                    return this.eval(environment).call(position, environment, values);
                }
                environment.error(position, StringUtil.methodMatchingError(ZenNativeMember.this.methods, values));
                return new ExpressionInvalid(position);
            }
            return new ExpressionCallStatic(position, environment, method, values);
        }

        @Override
        public ZenType[] predictCallTypes(int numArguments) {
            return JavaMethod.predict(ZenNativeMember.this.methods, numArguments);
        }

        @Override
        public IZenSymbol toSymbol() {
            return new StaticSymbol();
        }

        @Override
        public ZenType getType() {
            return ZenNativeMember.this.getter != null ? ZenNativeMember.this.getter.getReturnType() : (ZenNativeMember.this.setter != null ? ZenNativeMember.this.setter.getParameterTypes()[0] : null);
        }

        @Override
        public ZenType toType(IEnvironmentGlobal environment) {
            environment.error(this.position, "not a valid type");
            return ZenType.ANY;
        }
    }

    private class InstanceGetValue
    implements IPartialExpression {
        private final ZenPosition position;
        private final IPartialExpression value;

        public InstanceGetValue(ZenPosition position, IPartialExpression value) {
            this.position = position;
            this.value = value;
        }

        @Override
        public Expression eval(IEnvironmentGlobal environment) {
            if (ZenNativeMember.this.getter != null) {
                return new ExpressionCallVirtual(this.position, environment, ZenNativeMember.this.getter, this.value.eval(environment), new Expression[0]);
            }
            environment.error(this.position, "No getter available");
            ZenType type = this.getType();
            return new ExpressionInvalid(this.position, type == null ? ZenType.ANY : type);
        }

        @Override
        public Expression assign(ZenPosition position, IEnvironmentGlobal environment, Expression other) {
            if (ZenNativeMember.this.setter != null) {
                return new ExpressionCallVirtual(position, environment, ZenNativeMember.this.setter, this.value.eval(environment), other);
            }
            environment.error(position, "No setter available");
            return new ExpressionInvalid(position, ZenType.VOID);
        }

        @Override
        public IPartialExpression getMember(ZenPosition position, IEnvironmentGlobal environment, String name) {
            ZenType type = this.getType();
            if (type == null) {
                environment.error(position, "No such member: " + name);
                return new ExpressionInvalid(position);
            }
            return type.getMember(position, environment, this, name);
        }

        @Override
        public Expression call(ZenPosition position, IEnvironmentMethod environment, Expression ... values) {
            IJavaMethod method = JavaMethod.select(false, ZenNativeMember.this.methods, environment, values);
            if (method == null) {
                if (ZenNativeMember.this.getter != null && this.getType() instanceof ZenTypeFunctionCallable) {
                    return this.eval(environment).call(position, environment, values);
                }
                environment.error(position, StringUtil.methodMatchingError(ZenNativeMember.this.methods, values));
                return new ExpressionInvalid(position);
            }
            return new ExpressionCallVirtual(position, environment, method, this.value.eval(environment), values);
        }

        @Override
        public ZenType[] predictCallTypes(int numArguments) {
            return JavaMethod.predict(ZenNativeMember.this.methods, numArguments);
        }

        @Override
        public IZenSymbol toSymbol() {
            return null;
        }

        @Override
        public ZenType getType() {
            return ZenNativeMember.this.getter != null ? ZenNativeMember.this.getter.getReturnType() : (ZenNativeMember.this.setter != null ? ZenNativeMember.this.setter.getParameterTypes()[0] : null);
        }

        @Override
        public ZenType toType(IEnvironmentGlobal environment) {
            environment.error(this.position, "not a valid type");
            return ZenType.ANY;
        }
    }
}

