/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type;

import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.ZenClassWriter;
import stanhebben.zenscript.definitions.ParsedFunctionArgument;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionFunctionCall;
import stanhebben.zenscript.expression.ExpressionInvalid;
import stanhebben.zenscript.expression.ExpressionNull;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeFunction;
import stanhebben.zenscript.util.ZenPosition;

public class ZenTypeFunctionCallable
extends ZenTypeFunction {
    private final String className;
    private final String descriptor;
    private final String interfaceName;

    public ZenTypeFunctionCallable(ZenType returnType, List<ParsedFunctionArgument> arguments, String className, String descriptor) {
        super(returnType, arguments);
        this.className = className;
        this.descriptor = descriptor;
        this.interfaceName = ZenTypeFunctionCallable.makeInterfaceName(returnType, this.argumentTypes);
    }

    public ZenTypeFunctionCallable(ZenType returnType, ZenType[] argumentTypes, String className, String descriptor) {
        super(returnType, argumentTypes);
        this.className = className;
        this.descriptor = descriptor;
        this.interfaceName = ZenTypeFunctionCallable.makeInterfaceName(returnType, argumentTypes);
    }

    public ZenTypeFunctionCallable(ZenType returnType, ZenType[] argumentTypes, String className) {
        super(returnType, argumentTypes);
        this.className = className;
        StringBuilder sb = new StringBuilder("(");
        Arrays.stream(argumentTypes).map(ZenType::getSignature).forEach(sb::append);
        sb.append(")").append(returnType.getSignature());
        this.descriptor = sb.toString();
        this.interfaceName = ZenTypeFunctionCallable.makeInterfaceName(returnType, argumentTypes);
    }

    public static String makeInterfaceName(ZenType returnType, ZenType[] argumentTypes) {
        StringJoiner stringJoiner = new StringJoiner("_");
        for (ZenType argumentType : argumentTypes) {
            stringJoiner.add(argumentType.getNameForInterfaceSignature());
        }
        stringJoiner.add("to");
        stringJoiner.add(returnType.getNameForInterfaceSignature());
        stringJoiner.add("generated_interface");
        return stringJoiner.toString();
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public String getSignature() {
        return "L" + this.getInterfaceName() + ";";
    }

    @Override
    public Expression call(ZenPosition position, IEnvironmentGlobal environment, Expression receiver, Expression ... arguments) {
        if (arguments.length != this.argumentTypes.length) {
            environment.error(position, "Expected " + this.argumentTypes.length + " parameters but got " + arguments.length);
            return new ExpressionInvalid(position, this.returnType);
        }
        Expression[] expressions = new Expression[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            expressions[i] = arguments[i].cast(position, environment, this.argumentTypes[i]);
        }
        return new ExpressionFunctionCall(position, expressions, this.returnType, receiver, this.interfaceName, this.descriptor);
    }

    @Override
    public ZenType[] predictCallTypes(int numArguments) {
        return Arrays.copyOf(this.argumentTypes, numArguments);
    }

    @Override
    public Class toJavaClass() {
        return null;
    }

    @Override
    public Type toASMType() {
        return Type.getType((String)this.getSignature());
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Override
    public Expression defaultValue(ZenPosition position) {
        return new ExpressionNull(position);
    }

    public void writeInterfaceClass(IEnvironmentGlobal environment) {
        if (environment.containsClass(this.interfaceName)) {
            return;
        }
        ZenClassWriter cw = new ZenClassWriter(2);
        cw.visit(50, 5633, this.interfaceName, null, "java/lang/Object", new String[0]);
        cw.visitSource("generated_interface", null);
        MethodVisitor accept = cw.visitMethod(1025, "accept", this.descriptor, null, null);
        accept.visitEnd();
        cw.visitEnd();
        environment.putClass(this.interfaceName, cw.toByteArray());
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public String getNameForInterfaceSignature() {
        return this.interfaceName;
    }
}

