/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.brewing;

import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.api.recipes.IBrewingManager;
import crafttweaker.mc1120.brewing.ActionAddBrewingRecipe;
import crafttweaker.mc1120.brewing.ActionFixVanillaBrewingRecipes;
import crafttweaker.mc1120.brewing.ActionRemoveBrewingRecipe;
import crafttweaker.mc1120.brewing.ActionRemoveBrewingRecipeForIngredient;
import crafttweaker.mc1120.brewing.IBrewingAction;
import crafttweaker.mc1120.util.CraftTweakerHacks;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class MCBrewing
implements IBrewingManager {
    private static final List<Tuple<IIngredient, IIngredient>> toRemoveVanillaRecipes = new ArrayList<Tuple<IIngredient, IIngredient>>();
    private static final List<IBrewingRecipe> allBrewingRecipes = (List)CraftTweakerHacks.getPrivateStaticObject(BrewingRecipeRegistry.class, "recipes");
    public static final List<IBrewingAction> brewingActions = new ArrayList<IBrewingAction>();

    @Override
    public void addBrew(IIngredient input, IIngredient ingredient, IItemStack output, boolean hidden) {
        brewingActions.add(new ActionAddBrewingRecipe(input, new IIngredient[]{ingredient}, output, hidden));
    }

    @Override
    public void addBrew(IIngredient input, IIngredient[] ingredients, IItemStack output, boolean hidden) {
        brewingActions.add(new ActionAddBrewingRecipe(input, ingredients, output, hidden));
    }

    @Override
    public void removeRecipe(IItemStack input, IItemStack ingredient) {
        MCBrewing.addFixVanillaRecipesAction();
        toRemoveVanillaRecipes.add((Tuple<IIngredient, IIngredient>)new Tuple((Object)input, (Object)ingredient));
        brewingActions.add(new ActionRemoveBrewingRecipe(input, ingredient, allBrewingRecipes));
    }

    @Override
    public void removeRecipe(IItemStack ingredient) {
        MCBrewing.addFixVanillaRecipesAction();
        toRemoveVanillaRecipes.add((Tuple<IIngredient, IIngredient>)new Tuple((Object)IngredientAny.INSTANCE, (Object)ingredient));
        brewingActions.add(new ActionRemoveBrewingRecipeForIngredient(ingredient, allBrewingRecipes));
    }

    private static void addFixVanillaRecipesAction() {
        if (toRemoveVanillaRecipes.isEmpty()) {
            brewingActions.add(new ActionFixVanillaBrewingRecipes(toRemoveVanillaRecipes, allBrewingRecipes));
        }
    }
}

