/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.blocks.BlockPusher;
import com.rwtema.funkylocomotion.blocks.TileSlider;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.helper.ItemHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSlider
extends BlockPusher {
    public static final PropertyInteger SUB_ROTATION = PropertyInteger.func_177719_a((String)"sub_rot", (int)0, (int)3);
    private int[][] map;

    public BlockSlider() {
        this.init();
        this.func_149663_c("funkylocomotion:slider");
        this.setRegistryName("funkylocomotion:slider");
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    private void init() {
        this.map = new int[][]{{9, 9, 2, 0, 3, 1}, {9, 9, 0, 2, 3, 1}, {0, 2, 9, 9, 3, 1}, {0, 2, 9, 9, 1, 3}, {0, 2, 1, 3, 9, 9}, {0, 2, 3, 1, 9, 9}};
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return state;
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N);
        TileSlider tile = BlockHelper.getTileEntitySafely(worldIn, pos, TileSlider.class);
        if (tile != null) {
            EnumFacing slideDir = tile.getSlideDir();
            int value = this.map[facing.ordinal()][slideDir.ordinal()];
            if (value != 9) {
                state = state.func_177226_a((IProperty)SUB_ROTATION, (Comparable)Integer.valueOf(value));
            }
        }
        return state;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return false;
        }
        ItemStack item = playerIn.func_184586_b(hand);
        if (!ItemHelper.isWrench(item)) {
            return false;
        }
        int meta = this.func_176201_c(state);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (playerIn.func_70093_af()) {
            if (tile != null && tile.getClass() == TileSlider.class) {
                ((TileSlider)tile).rotateAboutAxis();
                BlockHelper.markBlockForUpdate(worldIn, pos);
                return true;
            }
        } else {
            if (side.ordinal() == meta) {
                side = side.func_176734_d();
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)side), 3);
            if (tile != null && tile.getClass() == TileSlider.class) {
                ((TileSlider)tile).getSlideDir();
                BlockHelper.markBlockForUpdate(worldIn, pos);
            }
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileSlider();
    }

    @Override
    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDirectional.field_176387_N, SUB_ROTATION});
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockDirectional.field_176387_N)).ordinal();
    }

    @Override
    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.values()[meta % 6]);
        return state;
    }
}

