/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import java.util.Collections;
import java.util.ListIterator;
import java.util.Set;
import java.util.WeakHashMap;
import landmaster.plustic.api.Toggle;
import landmaster.plustic.util.Coord4D;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.tools.Kama;

public class Global
extends AbstractTrait {
    public static final Global global = new Global();
    private static final Set<Block> warnedBlocks = Collections.newSetFromMap(new WeakHashMap());

    public Global() {
        super("global", 16769265);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Toggle.addToggleable(this.identifier);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void blockDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.getWorld().field_72995_K || event.getHarvester() == null) {
            return;
        }
        ItemStack tool = DualToolHarvestUtils.getItemstackToUse((EntityLivingBase)event.getHarvester(), (IBlockState)event.getState());
        if (!TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.getIdentifier())) {
            return;
        }
        this.__blockHarvestDrops(tool, event);
    }

    private void __blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
        if (!Toggle.getToggleState(tool, this.identifier)) {
            return;
        }
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)tool);
        if (nbt0.func_150297_b("global", 10) && ToolHelper.isToolEffective2((ItemStack)tool, (IBlockState)event.getState())) {
            ItemStack stk;
            NBTTagCompound nbt = nbt0.func_74775_l("global");
            Coord4D coord = Coord4D.fromNBT(nbt);
            if (coord.pos().equals((Object)event.getPos())) {
                return;
            }
            TileEntity te = coord.TE();
            if (te == null) {
                return;
            }
            IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[nbt.func_74771_c("facing")]);
            if (ih == null) {
                return;
            }
            try {
                ListIterator<ItemStack> dummy = event.getDrops().listIterator();
                if (dummy.hasNext()) {
                    ItemStack is = (ItemStack)dummy.next();
                    dummy.set(is);
                }
            }
            catch (UnsupportedOperationException e) {
                if (!warnedBlocks.contains(event.getState().func_177230_c())) {
                    FMLLog.bigWarning((String)("Block " + event.getState().func_177230_c() + " implements block drops incorrectly. It appears that it overrides the OFFICIALLY DEPRECATED method getDrops(IBlockAccess, BlockPos, IBlockState, int) instead of the correct method getDrops(NonNullList, IBlockAccess, BlockPos, IBlockState, int). This prevents features such as PlusTiC's Global Traveler from working properly with these blocks.\nUSERS: This is a BUG in the mod " + event.getState().func_177230_c().getRegistryName().func_110624_b() + "; report this to them!"), (Object[])new Object[0]);
                    warnedBlocks.add(event.getState().func_177230_c());
                }
                return;
            }
            ListIterator<ItemStack> it = event.getDrops().listIterator();
            ItemStack keptSeed = ItemStack.field_190927_a;
            while (it.hasNext()) {
                stk = (ItemStack)it.next();
                if (event.getWorld().field_73012_v.nextFloat() > event.getDropChance()) {
                    it.remove();
                    continue;
                }
                if (!(tool.func_77973_b() instanceof Kama) || !(stk.func_77973_b() instanceof IPlantable) || !keptSeed.func_190926_b()) continue;
                keptSeed = stk.func_77979_a(1);
            }
            if (!(tool.func_77973_b() instanceof Kama) || !keptSeed.func_190926_b()) {
                it = event.getDrops().listIterator();
                block3: while (it.hasNext()) {
                    stk = (ItemStack)it.next();
                    for (int j = 0; j < ih.getSlots(); ++j) {
                        ItemStack res = ih.insertItem(j, stk, false);
                        if (res.func_190926_b()) {
                            it.remove();
                            continue block3;
                        }
                        it.set(res);
                        stk = res;
                    }
                }
            }
            if (!keptSeed.func_190926_b()) {
                event.getDrops().add(keptSeed);
            }
            event.setDropChance(1.0f);
            te.func_70296_d();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropEvent(LivingDropsEvent event) {
        World world0 = event.getEntity().func_130014_f_();
        if (world0.field_72995_K || event.getEntityLiving().func_110143_aJ() > 0.0f) {
            return;
        }
        ItemStack weapon = this.getWeapon(event.getSource());
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)weapon);
        if (TinkerUtil.hasTrait((NBTTagCompound)nbt0, (String)this.getIdentifier())) {
            if (!Toggle.getToggleState(weapon, this.identifier)) {
                return;
            }
            if (nbt0.func_150297_b("global", 10)) {
                NBTTagCompound nbt = nbt0.func_74775_l("global");
                Coord4D coord = Coord4D.fromNBT(nbt);
                TileEntity te = coord.TE();
                if (te == null) {
                    return;
                }
                IItemHandler ih = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.field_82609_l[nbt.func_74771_c("facing")]);
                if (ih == null) {
                    return;
                }
                ListIterator it = event.getDrops().listIterator();
                block0: while (it.hasNext()) {
                    EntityItem enti = (EntityItem)it.next();
                    ItemStack stk = enti.func_92059_d();
                    for (int j = 0; j < ih.getSlots(); ++j) {
                        ItemStack res = ih.insertItem(j, stk, false);
                        if (res.func_190926_b()) {
                            it.remove();
                            continue block0;
                        }
                        enti.func_92058_a(res);
                        stk = res;
                    }
                }
                te.func_70296_d();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerUse(PlayerInteractEvent.RightClickBlock event) {
        NBTTagCompound nbt = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        if (event.getWorld().field_72995_K || event.isCanceled() || !event.getEntityPlayer().func_70093_af() || event.getItemStack() == null || event.getFace() == null || !TinkerUtil.hasTrait((NBTTagCompound)nbt, (String)this.getIdentifier())) {
            return;
        }
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te == null || te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, event.getFace()) == null) {
            return;
        }
        NBTTagCompound global = new NBTTagCompound();
        Coord4D coord = new Coord4D(event.getPos(), event.getWorld());
        coord.toNBT(global);
        global.func_74774_a("facing", (byte)event.getFace().ordinal());
        nbt.func_74782_a("global", (NBTBase)global);
        event.getItemStack().func_77982_d(nbt);
        event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("msg.plustic.globalmodifier.set", new Object[]{coord.xCoord, coord.yCoord, coord.zCoord, coord.dimensionId}));
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void tooltip(ItemTooltipEvent event) {
        NBTTagCompound nbt0 = TagUtil.getTagSafe((ItemStack)event.getItemStack());
        if (event.isCanceled() || event.getItemStack() == null || !TinkerUtil.hasTrait((NBTTagCompound)nbt0, (String)this.getIdentifier())) {
            return;
        }
        if (nbt0.func_150297_b("global", 10)) {
            NBTTagCompound nbt = nbt0.func_74775_l("global");
            event.getToolTip().add(I18n.func_135052_a((String)"tooltip.plustic.globalmodifier.info", (Object[])new Object[]{nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"), nbt.func_74762_e("dim")}));
        }
    }

    private ItemStack getWeapon(DamageSource source) {
        Entity entity;
        if (source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityLivingBase) {
            return ((EntityLivingBase)entity).func_184614_ca();
        }
        return null;
    }
}

