/*
 * Decompiled with CFR 0.152.
 */
package landmaster.plustic.traits;

import landmaster.plustic.api.Toggle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class EntityCameoTrait
extends AbstractTrait {
    protected final ICameoFactory factory;

    public EntityCameoTrait(String identifier, int color, ICameoFactory factory) {
        super(identifier, color);
        this.factory = factory;
        MinecraftForge.EVENT_BUS.register((Object)this);
        Toggle.addToggleable(identifier);
    }

    public void afterHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damageDealt, boolean wasCritical, boolean wasHit) {
        if (wasHit && target.func_70089_S() && random.nextFloat() < 0.38f && Toggle.getToggleState(tool, this.identifier)) {
            this.summonCameo((Entity)player, target);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void defend(LivingHurtEvent event) {
        ItemStack tool = event.getEntityLiving().func_184614_ca();
        if (event.getEntity().func_130014_f_().field_72995_K || !Toggle.getToggleState(tool, this.identifier) || event.isCanceled() || !TinkerUtil.hasTrait((NBTTagCompound)TagUtil.getTagSafe((ItemStack)tool), (String)this.getIdentifier()) || !(event.getSource() instanceof EntityDamageSource) || !(event.getSource().func_76346_g() instanceof EntityLivingBase)) {
            return;
        }
        if (random.nextFloat() < 0.38f) {
            EntityLivingBase target = (EntityLivingBase)event.getSource().func_76346_g();
            this.summonCameo(event.getEntity(), target);
        }
    }

    protected void summonCameo(Entity summoner, EntityLivingBase target) {
        Entity cameo = this.factory.create(summoner.func_130014_f_(), summoner, target);
        cameo.func_70107_b(summoner.field_70165_t + random.nextDouble() * 4.0 - 2.0, summoner.field_70163_u, summoner.field_70161_v + random.nextDouble() * 4.0 - 2.0);
        summoner.func_130014_f_().func_72838_d(cameo);
    }

    @FunctionalInterface
    public static interface ICameoFactory {
        public Entity create(World var1, Entity var2, EntityLivingBase var3);
    }
}

