/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.entity;

import cofh.thermaldynamics.block.BlockDuct;
import cofh.thermaldynamics.duct.ConnectionType;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.GridTransport;
import cofh.thermaldynamics.duct.tiles.DuctToken;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.IGridTileRoute;
import cofh.thermaldynamics.multiblock.Route;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;

public abstract class DuctUnitTransportBase
extends DuctUnit<DuctUnitTransportBase, GridTransport, TransportDestination>
implements IGridTileRoute<DuctUnitTransportBase, GridTransport> {
    public DuctUnitTransportBase(TileGrid parent, Duct duct) {
        super(parent, duct);
    }

    @Override
    @Nonnull
    public DuctToken<DuctUnitTransportBase, GridTransport, TransportDestination> getToken() {
        return DuctToken.TRANSPORT;
    }

    public void advanceEntity(EntityTransport t) {
        t.progress = (byte)(t.progress + t.step);
        if (t.myPath == null) {
            t.bouncePassenger(this);
        } else if (t.progress >= 100) {
            t.progress = (byte)(t.progress % 100);
            this.advanceToNextTile(t);
        } else if (t.progress >= 50 && t.progress - t.step < 50 && (t.reRoute || this.getRenderConnectionType(t.direction) == BlockDuct.ConnectionType.NONE)) {
            t.bouncePassenger(this);
        }
    }

    public void advanceToNextTile(EntityTransport t) {
    }

    public IGridTile getPhysicalConnectedSide(byte direction) {
        return super.getConnectedSide(direction);
    }

    public boolean advanceEntityClient(EntityTransport t) {
        t.progress = (byte)(t.progress + t.step);
        return t.progress >= 100 && !t.trySimpleAdvance();
    }

    @Override
    public int getWeight() {
        return 1;
    }

    @Override
    public boolean canStuffItem() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return this.nodeMask != 0;
    }

    @Override
    public int getMaxRange() {
        return 0;
    }

    @Override
    public ConnectionType getConnectionType(byte side) {
        return this.parent.getConnectionType(side);
    }

    @Override
    public DuctUnitTransportBase getCachedTile(byte side) {
        return ((DuctUnitTransportBase[])this.ductCache)[side];
    }

    @Override
    public byte getStuffedSide() {
        return 0;
    }

    @Override
    public boolean acceptingStuff() {
        return false;
    }

    public abstract boolean isRoutable();

    public abstract boolean isCrossover();

    public boolean isLongRange() {
        return !this.isRoutable() && !this.isCrossover();
    }

    public boolean hasTooManyConnections() {
        return false;
    }

    public abstract Route getRoute(Entity var1, int var2, byte var3);

    protected TransportDestination[] createTileCache() {
        return new TransportDestination[6];
    }

    protected DuctUnitTransportBase[] createDuctCache() {
        return new DuctUnitTransportBase[6];
    }

    public static class TransportDestination {
    }
}

