/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.common.matching;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import wanion.lib.common.ICopyable;
import wanion.lib.common.ISmartNBT;
import wanion.lib.common.control.IControlNameable;
import wanion.lib.common.matching.matcher.AbstractMatcher;
import wanion.lib.common.matching.matcher.ItemStackMatcher;
import wanion.lib.common.matching.matcher.MatcherEnum;

public class Matching
implements ISmartNBT,
ICopyable<Matching>,
IControlNameable {
    private final List<ItemStack> itemStacks;
    private final int number;
    private final String stringNumber;
    private final boolean shouldUseNbt;
    private AbstractMatcher<?> matcher = new ItemStackMatcher(this);

    public Matching(@Nonnull List<ItemStack> itemStacks, int number) {
        this(itemStacks, number, false);
    }

    public Matching(@Nonnull List<ItemStack> itemStacks, int number, boolean shouldUseNbt) {
        this.itemStacks = itemStacks;
        this.number = number;
        this.stringNumber = Integer.toString(this.number);
        this.shouldUseNbt = shouldUseNbt;
    }

    public Matching(@Nonnull List<ItemStack> itemStacks, int number, boolean shouldUseNbt, @Nonnull NBTTagCompound tagToRead) {
        this.itemStacks = itemStacks;
        this.number = number;
        this.stringNumber = Integer.toString(this.number);
        this.shouldUseNbt = shouldUseNbt;
        this.readNBT(tagToRead);
    }

    public void resetMatcher() {
        this.matcher = new ItemStackMatcher(this);
    }

    public void nextMatcher() {
        this.matcher = this.matcher.next();
    }

    public AbstractMatcher<?> getMatcher() {
        return this.matcher;
    }

    public void setMatcher(@Nonnull AbstractMatcher<?> matcher) {
        this.matcher = matcher.validate();
    }

    public ItemStack getStack() {
        return this.itemStacks.get(this.number);
    }

    public boolean shouldUseNbt() {
        return this.shouldUseNbt;
    }

    @Override
    @Nonnull
    public NBTTagCompound writeNBT() {
        NBTTagCompound matcherNBT = new NBTTagCompound();
        matcherNBT.func_74768_a("number", this.number);
        matcherNBT.func_74768_a("matcherType", this.matcher.getMatcherEnum().ordinal());
        matcherNBT.func_74782_a("matcher", (NBTBase)this.matcher.writeNBT());
        return matcherNBT;
    }

    @Override
    public void readNBT(@Nonnull NBTTagCompound nbtTagCompound) {
        MatcherEnum matcherEnum = MatcherEnum.values()[nbtTagCompound.func_74762_e("matcherType")];
        AbstractMatcher matcher = matcherEnum.getMatcher(this);
        matcher.readNBT(nbtTagCompound.func_74775_l("matcher"));
        this.setMatcher(matcher);
    }

    @Override
    @Nonnull
    public Matching copy() {
        return new Matching(this.itemStacks, this.number, this.shouldUseNbt, this.writeNBT());
    }

    @Override
    @Nonnull
    public String getControlName() {
        return "wanionlib.matching.control";
    }

    public int hashCode() {
        return this.number;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Matching) {
            Matching matching = (Matching)obj;
            if (matching.number == this.number) {
                return this.matcher.equals(matching.matcher);
            }
            return false;
        }
        return false;
    }
}

