/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.gui;

import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.lib.Reference;
import wanion.lib.client.gui.WElement;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.common.control.energy.EnergyControl;

@SideOnly(value=Side.CLIENT)
public class EnergyElement
extends WElement {
    protected final EnergyControl energyControl;

    public EnergyElement(@Nonnull EnergyControl energyControl, @Nonnull WGuiContainer<?> wGuiContainer, int x, int y) {
        super(wGuiContainer, x, y, 18, 54);
        this.energyControl = energyControl;
    }

    @Override
    public void draw(@Nonnull WInteraction wInteraction) {
        this.wGuiContainer.field_146297_k.func_110434_K().func_110577_a(Reference.GUI_TEXTURES);
        Gui.func_146110_a((int)this.getUsableX(), (int)this.getUsableY(), (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)128.0f, (float)128.0f);
        int size = this.scalePowerCentage();
        if (size != 0) {
            Gui.func_146110_a((int)this.getUsableX(), (int)(this.getUsableY() + this.height - size), (float)18.0f, (float)(this.height - size), (int)18, (int)size, (float)128.0f, (float)128.0f);
        }
    }

    @Override
    public void drawForeground(@Nonnull WInteraction interaction) {
        if (interaction.isHovering(this)) {
            this.wGuiContainer.func_146283_a(Lists.newArrayList((Object[])new String[]{this.energyControl.getEnergyStored() + " / " + this.energyControl.getMaxEnergyStored() + " FE", "", TextFormatting.GOLD + I18n.func_135052_a((String)"wanionlib.consumes", (Object[])new Object[]{this.energyControl.getEnergyUsage()}), TextFormatting.GOLD + I18n.func_135052_a((String)"wanionlib.per.operation", (Object[])new Object[0])}), this.getTooltipX(interaction), this.getTooltipY(interaction));
        }
    }

    @Override
    public boolean canInteractWith(@Nonnull WInteraction wInteraction) {
        return false;
    }

    private int scalePowerCentage() {
        int energyStored = this.energyControl.getEnergyStored();
        return energyStored != 0 ? (int)((double)(this.height * energyStored) / (double)this.energyControl.getMaxEnergyStored()) : 0;
    }
}

