/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items.itemmatching;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.api.recipes.ICustomRecipeMatching;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.items.itemmatching.IMatcher;
import com.rwtema.extrautils2.items.itemmatching.MultiMatcher;
import com.rwtema.extrautils2.utils.datastructures.ItemRef;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class Matchers {
    public static Predicate<ItemStack> createMatcher(Object object, boolean crafting) {
        if (object == null) {
            return ItemRef.NULL;
        }
        if (object instanceof ItemStack) {
            return Matchers.matchItemStackIS((ItemStack)object, crafting);
        }
        if (object instanceof IMatcher) {
            return (IMatcher)object;
        }
        if (object instanceof Predicate) {
            return (Predicate)object;
        }
        if (object instanceof Block) {
            return Matchers.matchItemStackIS(new ItemStack((Block)object), crafting);
        }
        if (object instanceof Item) {
            return Matchers.matchItemStackIS(new ItemStack((Item)object), crafting);
        }
        if (object instanceof IItemStackMaker) {
            return Matchers.matchItemStackIS(((IItemStackMaker)object).newStack(), crafting);
        }
        if (object instanceof String) {
            NonNullList ores = OreDictionary.getOres((String)((String)object));
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ItemStack ore : ores) {
                builder.add((Object)Matchers.matchItemStackIS(ore, crafting));
            }
            return new MultiMatcher((Collection<? extends Predicate<ItemStack>>)builder.build());
        }
        if (object instanceof List) {
            List list = (List)object;
            if (list.size() == 1) {
                return Matchers.createMatcher(list.get(0), crafting);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Object o : list) {
                builder.add(Matchers.createMatcher(o, crafting));
            }
            return new MultiMatcher((Collection<? extends Predicate<ItemStack>>)builder.build());
        }
        throw new IllegalArgumentException("Unable to process " + object);
    }

    private static IMatcher matchItemStackIS(ItemStack stack, boolean crafting) {
        if (crafting) {
            return Matchers.matchCrafting(stack);
        }
        return ItemRef.wrap(stack);
    }

    public static IMatcher matchCrafting(final ItemStack stack) {
        if (StackHelper.isNull(stack)) {
            return ItemRef.NULL;
        }
        Item item = stack.func_77973_b();
        if (item == StackHelper.nullItem()) {
            return ItemRef.NULL;
        }
        if (item instanceof ICustomRecipeMatching) {
            final ICustomRecipeMatching matching = (ICustomRecipeMatching)item;
            return new IMatcher(){

                @Override
                public boolean matchesItemStack(@Nullable ItemStack t) {
                    return matching.itemsMatch(t, stack);
                }
            };
        }
        return new IMatcher(){

            @Override
            public boolean matchesItemStack(@Nullable ItemStack t) {
                return t != null && OreDictionary.itemMatches((ItemStack)stack, (ItemStack)t, (boolean)false);
            }
        };
    }
}

