/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend;

import com.rwtema.extrautils2.backend.XUItemFlat;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.compatibility.StackHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class XUItemFlatMetadata
extends XUItemFlat {
    private final String[] textures;

    public XUItemFlatMetadata(String ... textures) {
        this.textures = textures;
        if (textures.length > 1) {
            this.func_77627_a(true);
        }
    }

    @Override
    public void getSubItemsBase(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        if (this.textures.length > 1) {
            for (int i = 0; i < this.textures.length; ++i) {
                subItems.add(new ItemStack(itemIn, 1, i));
            }
        } else {
            super.getSubItemsBase(itemIn, tab, subItems);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        Textures.register(this.textures);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        int damage;
        int n = damage = StackHelper.isNonNull(itemStack) ? itemStack.func_77952_i() : 0;
        if (damage < 0) {
            damage = 0;
        }
        if (damage >= this.textures.length) {
            damage = this.textures.length - 1;
        }
        return this.textures[damage];
    }

    @Override
    public int getMaxMetadata() {
        return this.textures.length - 1;
    }

    @Override
    public boolean allowOverride() {
        return true;
    }

    @Override
    public String getModelSubName(int metadata) {
        if (metadata < 0) {
            metadata = 0;
        }
        if (metadata >= this.textures.length) {
            metadata = this.textures.length - 1;
        }
        return this.textures[metadata];
    }
}

