/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.network.NetworkSettings;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.network.PacketColorCache;

public class PacketColorRequest
implements IMessageHandler<ColorRequestMessage, IMessage> {
    public IMessage onMessage(ColorRequestMessage message, MessageContext ctx) {
        HashMap<Integer, Tuple<Integer, String>> cache = new HashMap<Integer, Tuple<Integer, String>>();
        if (!message.requests.isEmpty()) {
            for (int id : message.requests) {
                IFluxNetwork network = FluxNetworkCache.instance.getNetwork(id);
                cache.put(id, (Tuple<Integer, String>)new Tuple((Object)(network.getSetting(NetworkSettings.NETWORK_COLOR) | 0xFF000000), (Object)(network.isInvalid() ? "NONE" : network.getSetting(NetworkSettings.NETWORK_NAME))));
            }
            return new PacketColorCache.ColorCacheMessage(cache);
        }
        return null;
    }

    public static class ColorRequestMessage
    implements IMessage {
        List<Integer> requests;

        public ColorRequestMessage() {
        }

        public ColorRequestMessage(List<Integer> requests) {
            this.requests = requests;
        }

        public void fromBytes(ByteBuf buf) {
            this.requests = new ArrayList<Integer>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                this.requests.add(buf.readInt());
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.requests.size());
            this.requests.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
        }
    }
}

