/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration;

import java.text.NumberFormat;
import java.util.function.Function;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.api.tiles.IFluxConnector;
import sonar.fluxnetworks.api.translate.FluxTranslate;
import sonar.fluxnetworks.api.utils.EnergyType;
import sonar.fluxnetworks.common.block.BlockFluxCore;
import sonar.fluxnetworks.common.core.FluxUtils;

public class TOPIntegration
implements Function<ITheOneProbe, Void> {
    @Override
    public Void apply(ITheOneProbe iTheOneProbe) {
        iTheOneProbe.registerProvider((IProbeInfoProvider)new FluxConnectorInfoProvider());
        iTheOneProbe.registerBlockDisplayOverride((IBlockDisplayOverride)new FluxConnectorDisplayOverride());
        return null;
    }

    public static class FluxConnectorDisplayOverride
    implements IBlockDisplayOverride {
        public boolean overrideStandardInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, EntityPlayer entityPlayer, World world, IBlockState iBlockState, IProbeHitData iProbeHitData) {
            TileEntity tile;
            if (iBlockState.func_177230_c() instanceof BlockFluxCore && (tile = world.func_175625_s(iProbeHitData.getPos())) instanceof IFluxConnector) {
                IFluxConnector flux = (IFluxConnector)tile;
                ItemStack pickBlock = flux.getDisplayStack().func_151001_c(flux.getCustomName());
                iProbeInfo.horizontal().item(pickBlock).vertical().itemLabel(pickBlock).text(TextStyleClass.MODNAME + "Flux Networks");
                return true;
            }
            return false;
        }
    }

    public static class FluxConnectorInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "fluxnetworks";
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, EntityPlayer entityPlayer, World world, IBlockState iBlockState, IProbeHitData iProbeHitData) {
            TileEntity tile;
            if (!FluxConfig.enableOneProbeBasicInfo && !FluxConfig.enableOneProbeAdvancedInfo) {
                return;
            }
            if (iBlockState.func_177230_c() instanceof BlockFluxCore && (tile = world.func_175625_s(iProbeHitData.getPos())) instanceof IFluxConnector) {
                IFluxConnector flux = (IFluxConnector)tile;
                if (FluxConfig.enableOneProbeBasicInfo) {
                    iProbeInfo.text(TextFormatting.AQUA + (flux.getNetwork().isInvalid() ? FluxTranslate.ERROR_NO_SELECTED.t() : flux.getNetwork().getNetworkName()));
                    iProbeInfo.text(FluxUtils.getTransferInfo(flux.getConnectionType(), EnergyType.RF, flux.getTransferChange()));
                    if (entityPlayer.func_70093_af()) {
                        if (flux.getConnectionType().isStorage()) {
                            iProbeInfo.text(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.GREEN + NumberFormat.getInstance().format(flux.getTransferBuffer()) + "RF");
                        } else {
                            iProbeInfo.text(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.GREEN + NumberFormat.getInstance().format(flux.getTransferBuffer()) + "RF");
                        }
                    } else if (flux.getConnectionType().isStorage()) {
                        iProbeInfo.text(FluxTranslate.ENERGY_STORED.t() + ": " + TextFormatting.GREEN + FluxUtils.format(flux.getTransferBuffer(), FluxUtils.TypeNumberFormat.COMPACT, "RF"));
                    } else {
                        iProbeInfo.text(FluxTranslate.INTERNAL_BUFFER.t() + ": " + TextFormatting.GREEN + FluxUtils.format(flux.getTransferBuffer(), FluxUtils.TypeNumberFormat.COMPACT, "RF"));
                    }
                }
                if (FluxConfig.enableOneProbeAdvancedInfo && (!FluxConfig.enableOneProbeSneaking || entityPlayer.func_70093_af())) {
                    iProbeInfo.text(FluxTranslate.TRANSFER_LIMIT.t() + ": " + TextFormatting.GREEN + (flux.getDisableLimit() ? FluxTranslate.UNLIMITED.t() : Long.valueOf(flux.getRawLimit())));
                    iProbeInfo.text(FluxTranslate.PRIORITY.t() + ": " + TextFormatting.GREEN + (flux.getSurgeMode() ? FluxTranslate.SURGE.t() : Integer.valueOf(flux.getRawPriority())));
                    if (flux.isForcedLoading()) {
                        iProbeInfo.text(TextFormatting.GOLD + FluxTranslate.FORCED_LOADING.t());
                    }
                }
            }
        }
    }
}

