/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.core;

import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.tiles.IFluxConnector;

public class ForgeEnergyWrapper
implements IEnergyStorage {
    private final IFluxConnector tile;
    @Nullable
    private final EnumFacing side;

    public ForgeEnergyWrapper(IFluxConnector tile, @Nullable EnumFacing side) {
        this.tile = tile;
        this.side = side;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.side != null && this.tile.getConnectionType().isPlug() && this.tile.isActive()) {
            return (int)this.tile.getTransferHandler().receiveFromSupplier(maxReceive, this.side, simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.tile.getTransferBuffer(), Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.tile.getMaxTransferLimit(), Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.tile.getConnectionType().isPlug();
    }
}

