/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.connection.transfer;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import sonar.fluxnetworks.api.energy.ITileEnergyHandler;

public class ConnectionTransfer {
    private final ITileEnergyHandler energyHandler;
    private final TileEntity tile;
    private final EnumFacing side;
    private final ItemStack displayStack;
    public long outbound;
    public long inbound;

    public ConnectionTransfer(ITileEnergyHandler energyHandler, @Nonnull TileEntity tile, @Nonnull EnumFacing dir) {
        this.energyHandler = energyHandler;
        this.tile = tile;
        this.side = dir.func_176734_d();
        this.displayStack = new ItemStack(tile.func_145838_q());
    }

    public long sendToTile(long amount, boolean simulate) {
        if (this.energyHandler.canAddEnergy(this.tile, this.side)) {
            long added = this.energyHandler.addEnergy(amount, this.tile, this.side, simulate);
            if (!simulate) {
                this.inbound += added;
            }
            return added;
        }
        return 0L;
    }

    public void onEnergyReceived(long amount) {
        this.outbound += amount;
    }

    public void onCycleStart() {
        this.outbound = 0L;
        this.inbound = 0L;
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public ItemStack getDisplayStack() {
        return this.displayStack;
    }
}

