/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.gui.EnumFeedbackInfo;
import sonar.fluxnetworks.api.network.IFluxNetwork;
import sonar.fluxnetworks.api.utils.NBTType;
import sonar.fluxnetworks.common.capabilities.DefaultSuperAdmin;
import sonar.fluxnetworks.common.connection.FluxNetworkCache;
import sonar.fluxnetworks.common.connection.FluxNetworkInvalid;
import sonar.fluxnetworks.common.core.EntityFireItem;
import sonar.fluxnetworks.common.data.FluxChunkManager;
import sonar.fluxnetworks.common.event.FluxConnectionEvent;
import sonar.fluxnetworks.common.handler.CapabilityHandler;
import sonar.fluxnetworks.common.handler.PacketHandler;
import sonar.fluxnetworks.common.handler.TileEntityHandler;
import sonar.fluxnetworks.common.integration.MekanismIntegration;
import sonar.fluxnetworks.common.integration.TOPIntegration;
import sonar.fluxnetworks.common.integration.oc.OCIntegration;
import sonar.fluxnetworks.common.network.PacketNetworkUpdate;
import sonar.fluxnetworks.common.network.PacketSuperAdmin;
import sonar.fluxnetworks.common.registry.RegistryBlocks;
import sonar.fluxnetworks.common.registry.RegistryItems;

public class CommonProxy {
    public boolean baublesLoaded;
    public boolean ocLoaded;
    public int admin_viewing_network_id = -1;
    public boolean detailed_network_view;
    public IFluxNetwork admin_viewing_network = FluxNetworkInvalid.instance;
    public static CreativeTabs creativeTabs = new CreativeTabs("fluxnetworks"){

        public ItemStack func_78016_d() {
            return new ItemStack(RegistryBlocks.FLUX_PLUG);
        }
    };

    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketHandler.registerMessages();
        TileEntityHandler.registerEnergyHandler();
        FluxConfig.init(event.getModConfigurationDirectory());
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("fluxnetworks", "Flux"), EntityFireItem.class, (String)"Flux", (int)0, (Object)FluxNetworks.instance, (int)64, (int)10, (boolean)true);
        if (Loader.isModLoaded((String)"mekanism")) {
            MekanismIntegration.preInit();
        }
        this.ocLoaded = Loader.isModLoaded((String)"opencomputers");
        this.baublesLoaded = Loader.isModLoaded((String)"baubles");
    }

    public void init(FMLInitializationEvent event) {
        DefaultSuperAdmin.register();
        FMLInterModComms.sendMessage((String)"carryon", (String)"blacklistBlock", (String)"fluxnetworks:*");
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)TOPIntegration.class.getName());
        if (this.ocLoaded) {
            OCIntegration.init();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)FluxNetworks.instance, FluxChunkManager::callback);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityHandler());
    }

    public void onServerStarted() {
    }

    public void onServerStopped() {
        FluxNetworkCache.instance.clearNetworks();
        FluxChunkManager.clear();
    }

    public void registerItemModel(Item item, int meta, String variant) {
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getSide().isServer()) {
            BlockPos pos;
            if (!FluxConfig.enableFluxRecipe) {
                return;
            }
            World world = event.getWorld();
            if (world.func_180495_p(pos = event.getPos()).func_177230_c().equals(Blocks.field_150343_Z) && world.func_180495_p(pos.func_177979_c(2)).func_177230_c().equals(Blocks.field_150357_h)) {
                List entities = world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos.func_177977_b()));
                if (entities.isEmpty()) {
                    return;
                }
                ArrayList s = Lists.newArrayList();
                AtomicInteger count = new AtomicInteger();
                entities.forEach(e -> {
                    if (e.func_92059_d().func_77973_b().equals(Items.field_151137_ax)) {
                        s.add(e);
                        count.addAndGet(e.func_92059_d().func_190916_E());
                    }
                });
                if (s.isEmpty()) {
                    return;
                }
                ItemStack stack = new ItemStack(RegistryItems.FLUX, count.getAndIncrement());
                s.forEach(Entity::func_70106_y);
                world.func_175698_g(pos);
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, stack));
                world.func_175656_a(pos.func_177977_b(), Blocks.field_150343_Z.func_176223_P());
                world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityAdded(EntityJoinWorldEvent event) {
        EntityItem entityItem;
        ItemStack stack;
        if (!FluxConfig.enableFluxRecipe || !FluxConfig.enableOldRecipe || event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof EntityItem && !(entity instanceof EntityFireItem) && !(stack = (entityItem = (EntityItem)entity).func_92059_d()).func_190926_b() && stack.func_77973_b() == Items.field_151137_ax) {
            EntityFireItem newEntity = new EntityFireItem(entityItem);
            entityItem.func_70106_y();
            int i = MathHelper.func_76128_c((double)(newEntity.field_70165_t / 16.0));
            int j = MathHelper.func_76128_c((double)(newEntity.field_70161_v / 16.0));
            event.getWorld().func_72964_e(i, j).func_76612_a((Entity)newEntity);
            event.getWorld().field_72996_f.add(newEntity);
            event.getWorld().func_72923_a((Entity)newEntity);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            for (IFluxNetwork network : FluxNetworkCache.instance.getAllNetworks()) {
                network.onEndServerTick();
            }
        }
    }

    @SubscribeEvent
    public void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.network.sendTo((IMessage)new PacketNetworkUpdate.NetworkUpdateMessage(new ArrayList<IFluxNetwork>(FluxNetworkCache.instance.getAllNetworks()), NBTType.NETWORK_GENERAL), (EntityPlayerMP)player);
            PacketHandler.network.sendTo((IMessage)new PacketSuperAdmin.SuperAdminMessage(DefaultSuperAdmin.isPlayerSuperAdmin(player)), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onFluxConnected(FluxConnectionEvent.Connected event) {
        if (!event.flux.getFluxWorld().field_72995_K) {
            event.flux.connect(event.network);
        }
    }

    @SubscribeEvent
    public void onFluxDisconnect(FluxConnectionEvent.Disconnected event) {
        if (!event.flux.getFluxWorld().field_72995_K) {
            event.flux.disconnect(event.network);
        }
    }

    public EnumFeedbackInfo getFeedback(boolean operation) {
        return null;
    }

    public void setFeedback(EnumFeedbackInfo info, boolean operation) {
    }

    public void receiveColorCache(Map<Integer, Tuple<Integer, String>> cache) {
    }

    public EntityPlayer getPlayer(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }
}

