/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.jei;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.util.vector.Quaternion;
import sonar.fluxnetworks.client.jei.FluxCraftingCategory;

public class FluxRecipeWrapper
implements IRecipeWrapper {
    public final ItemStack input;
    public final ItemStack output;

    public FluxRecipeWrapper(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        RenderItem itemRenderer = minecraft.func_175599_af();
        int value = FluxCraftingCategory.timer.getValue();
        double offset = (float)(value > 160 ? 160 - (value - 160) : value) / 10.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)63.0, (double)(19.0 + offset), (double)128.0);
        GlStateManager.func_179152_a((float)32.0f, (float)32.0f, (float)32.0f);
        GlStateManager.func_187444_a((Quaternion)FluxRecipeWrapper.makeQuaternion(30.0f, 45.0f, 0.0f));
        itemRenderer.func_181564_a(Item.func_150898_a((Block)Blocks.field_150343_Z).func_190903_i(), ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)63.0f, (float)49.0f, (float)96.0f);
        GlStateManager.func_179152_a((float)32.0f, (float)32.0f, (float)32.0f);
        GlStateManager.func_187444_a((Quaternion)FluxRecipeWrapper.makeQuaternion(30.0f, 45.0f, 0.0f));
        itemRenderer.func_181564_a(Item.func_150898_a((Block)Blocks.field_150357_h).func_190903_i(), ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)63.0f, (float)36.0f, (float)112.0f);
        GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
        ItemStack toDisplay = value > 160 ? this.output : this.input;
        GlStateManager.func_187444_a((Quaternion)FluxRecipeWrapper.makeQuaternion(toDisplay.func_77973_b() instanceof ItemBlock ? 30.0f : 0.0f, -90.0f + 180.0f * ((float)value / 320.0f), 0.0f));
        itemRenderer.func_181564_a(toDisplay, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String help = I18n.func_135052_a((String)"info.fluxnetworks.jei.leftclickhelp", (Object[])new Object[]{Blocks.field_150343_Z.func_149732_F()});
        fontRenderer.func_78276_b(help, (int)(64.0f - (float)fontRenderer.func_78256_a(help) / 2.0f), 68, -12566464);
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX > 40 && mouseX < 80 && mouseY > 8 && mouseY < 60) {
            return Lists.newArrayList((Object[])new String[]{"Y+2 = " + Blocks.field_150343_Z.func_149732_F(), "Y+1 = " + Items.field_151137_ax.func_190903_i().func_82833_r(), "Y+0 = " + Blocks.field_150357_h.func_149732_F()});
        }
        return Collections.emptyList();
    }

    public void getIngredients(@Nonnull IIngredients iIngredients) {
        iIngredients.setInput(VanillaTypes.ITEM, (Object)this.input);
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)this.output);
    }

    public static Quaternion makeQuaternion(float x, float y, float z) {
        float f = x * ((float)Math.PI / 180);
        float f1 = y * ((float)Math.PI / 180);
        float f2 = z * ((float)Math.PI / 180);
        float f3 = MathHelper.func_76126_a((float)(0.5f * f));
        float f4 = MathHelper.func_76134_b((float)(0.5f * f));
        float f5 = MathHelper.func_76126_a((float)(0.5f * f1));
        float f6 = MathHelper.func_76134_b((float)(0.5f * f1));
        float f7 = MathHelper.func_76126_a((float)(0.5f * f2));
        float f8 = MathHelper.func_76134_b((float)(0.5f * f2));
        return new Quaternion(f3 * f6 * f8 + f4 * f5 * f7, f4 * f5 * f8 - f3 * f6 * f7, f3 * f5 * f8 + f4 * f6 * f7, f4 * f6 * f8 - f3 * f5 * f7);
    }
}

