/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.recipe;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.TIntList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import wanion.lib.recipe.RecipeAttributes;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.UniDict;
import wanion.unidict.common.Util;
import wanion.unidict.recipe.AbstractRecipeResearcher;
import wanion.unidict.resource.UniResourceContainer;

public class ForgeRecipeResearcher
extends AbstractRecipeResearcher<ShapedOreRecipe, ShapelessOreRecipe> {
    private final Field oresField;

    public ForgeRecipeResearcher() {
        Field dummyOresField = null;
        try {
            dummyOresField = OreIngredient.class.getDeclaredField("ores");
            dummyOresField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.oresField = dummyOresField;
    }

    public int getShapedRecipeKey(@Nonnull ShapedOreRecipe recipe) {
        TIntList recipeKeys = Util.getList(recipe.func_192400_c().toArray(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    public int getShapelessRecipeKey(@Nonnull ShapelessOreRecipe recipe) {
        TIntList recipeKeys = Util.getList(recipe.func_192400_c().toArray(), this.resourceHandler);
        int recipeKey = 0;
        recipeKeys.sort();
        TIntIterator recipeKeysIterator = recipeKeys.iterator();
        while (recipeKeysIterator.hasNext()) {
            recipeKey += 31 * recipeKeysIterator.next();
        }
        return recipeKey;
    }

    @Nonnull
    public List<Class<? extends ShapedOreRecipe>> getShapedRecipeClasses() {
        Class<?> shapedCustomRecipe = null;
        try {
            if (Loader.isModLoaded((String)"forestry")) {
                shapedCustomRecipe = Class.forName("forestry.core.recipes.ShapedRecipeCustom");
            }
        }
        catch (ClassNotFoundException e) {
            UniDict.getLogger().error((Object)e);
        }
        return shapedCustomRecipe == null ? Collections.singletonList(ShapedOreRecipe.class) : Arrays.asList(ShapedOreRecipe.class, shapedCustomRecipe);
    }

    @Nonnull
    public List<Class<? extends ShapelessOreRecipe>> getShapelessRecipeClasses() {
        return Collections.singletonList(ShapelessOreRecipe.class);
    }

    public ShapedOreRecipe getNewShapedRecipe(@Nonnull ShapedOreRecipe recipe) {
        NonNullList recipeInputs = recipe.func_192400_c();
        int width = recipe.getRecipeWidth();
        int height = recipe.getRecipeHeight();
        int root = Math.max(width, height);
        Object[] newRecipeInputs = new Object[root * root];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Ingredient ingredient;
                Ingredient ingredient2 = ingredient = i < recipeInputs.size() ? (Ingredient)recipeInputs.get(i) : null;
                if (ingredient != null && ingredient.func_193365_a().length > 0) {
                    ItemStack itemStack = ingredient.func_193365_a()[0];
                    UniResourceContainer container = this.resourceHandler.getContainer(itemStack);
                    newRecipeInputs[y * root + x] = container != null ? (itemStacksOnly ? container.getMainEntry(itemStack) : container.name) : itemStack;
                } else if (ingredient instanceof OreIngredient) {
                    try {
                        newRecipeInputs[y * root + x] = this.uniOreDictionary.getName(this.oresField.get(ingredient));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
                ++x;
                ++i;
            }
        }
        UniResourceContainer outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        RecipeAttributes newRecipeAttributes = RecipeHelper.rawShapeToShape((Object[])newRecipeInputs);
        return new ShapedOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_shape." + newRecipeAttributes.shape), outputStack, newRecipeAttributes.actualShape);
    }

    public ShapedOreRecipe getNewShapedFromShapelessRecipe(@Nonnull ShapelessOreRecipe recipe) {
        NonNullList recipeInputs = recipe.func_192400_c();
        Object[] newRecipeInputs = new Object[9];
        for (int i = 0; i < 9; ++i) {
            Ingredient ingredient;
            Ingredient ingredient2 = ingredient = i < recipeInputs.size() ? (Ingredient)recipeInputs.get(i) : null;
            if (ingredient == null || ingredient.func_193365_a().length <= 0) continue;
            ItemStack itemStack = ingredient.func_193365_a()[0];
            UniResourceContainer container = this.resourceHandler.getContainer(itemStack);
            newRecipeInputs[i] = container != null ? (itemStacksOnly ? container.getMainEntry(itemStack) : container.name) : itemStack;
        }
        UniResourceContainer outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        RecipeAttributes newRecipeAttributes = RecipeHelper.rawShapeToShape((Object[])newRecipeInputs);
        return new ShapedOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_shape." + newRecipeAttributes.shape), outputStack, newRecipeAttributes.actualShape);
    }

    public ShapelessOreRecipe getNewShapelessRecipe(@Nonnull ShapelessOreRecipe recipe) {
        ArrayList inputs = new ArrayList();
        if (itemStacksOnly) {
            recipe.func_192400_c().forEach(ingredient -> {
                if (ingredient != null && ingredient.func_193365_a().length > 0) {
                    inputs.add(this.resourceHandler.getMainItemStack(ingredient.func_193365_a()[0]));
                }
            });
        } else {
            recipe.func_192400_c().forEach(ingredient -> {
                if (ingredient != null && ingredient.func_193365_a().length > 0) {
                    ItemStack input = ingredient.func_193365_a()[0];
                    UniResourceContainer container = this.resourceHandler.getContainer(input);
                    inputs.add(container != null ? container.name : input);
                }
            });
        }
        UniResourceContainer outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b());
        if (outputContainer == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        return new ShapelessOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_size." + inputs.size()), outputStack, inputs.toArray());
    }

    public ShapelessOreRecipe getNewShapelessFromShapedRecipe(@Nonnull ShapedOreRecipe recipe) {
        UniResourceContainer outputContainer;
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        if (itemStacksOnly) {
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (ingredient == null || ingredient.func_193365_a().length <= 0) continue;
                inputs.add(this.resourceHandler.getMainItemStack(ingredient.func_193365_a()[0]));
            }
        } else {
            for (Ingredient ingredient : recipe.func_192400_c()) {
                if (ingredient == null || ingredient.func_193365_a().length <= 0) continue;
                ItemStack input = ingredient.func_193365_a()[0];
                UniResourceContainer container = this.resourceHandler.getContainer(input);
                inputs.add((ItemStack)(container != null ? container.name : input));
            }
        }
        if ((outputContainer = this.resourceHandler.getContainer(recipe.func_77571_b())) == null) {
            return null;
        }
        int outputSize = recipe.func_77571_b().func_190916_E();
        ItemStack outputStack = outputContainer.getMainEntry(outputSize);
        return new ShapelessOreRecipe(new ResourceLocation("unidict", outputContainer.name + "_x" + outputSize + "_size." + inputs.size()), outputStack, inputs.toArray());
    }

    @Override
    public void postProcess() {
    }
}

