/*
 * Decompiled with CFR 0.152.
 */
package wanion.unidict.integration;

import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.ICentrifugeRecipe;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.utils.datastructures.ItemStackMap;
import forestry.factory.recipes.CarpenterRecipe;
import forestry.factory.recipes.CarpenterRecipeManager;
import forestry.factory.recipes.CentrifugeRecipe;
import forestry.factory.recipes.CentrifugeRecipeManager;
import forestry.factory.recipes.ISqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerContainerRecipe;
import forestry.factory.recipes.SqueezerRecipeManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import wanion.lib.common.Util;
import wanion.lib.recipe.RecipeAttributes;
import wanion.lib.recipe.RecipeHelper;
import wanion.unidict.integration.AbstractIntegrationThread;
import wanion.unidict.resource.UniResourceContainer;

final class ForestryIntegration
extends AbstractIntegrationThread {
    ForestryIntegration() {
        super("Forestry");
    }

    public String call() {
        try {
            this.fixCarpenterRecipes();
            this.fixCentrifugeRecipes();
            this.fixSqueezerRecipes();
        }
        catch (Exception e) {
            this.logger.error(this.threadName + e);
            e.printStackTrace();
        }
        return this.threadName + "All these bees... they can hurt, you know?";
    }

    private void fixCarpenterRecipes() {
        Set carpenterRecipes = (Set)Util.getField(CarpenterRecipeManager.class, (String)"recipes", null, Set.class);
        if (carpenterRecipes == null) {
            return;
        }
        ArrayList<CarpenterRecipe> newRecipes = new ArrayList<CarpenterRecipe>();
        Iterator carpenterRecipeIterator = carpenterRecipes.iterator();
        while (carpenterRecipeIterator.hasNext()) {
            ICarpenterRecipe carpenterRecipe = (ICarpenterRecipe)carpenterRecipeIterator.next();
            if (!(carpenterRecipe.getCraftingGridRecipe() instanceof ShapedRecipeCustom)) continue;
            ShapedRecipeCustom gridRecipe = (ShapedRecipeCustom)carpenterRecipe.getCraftingGridRecipe();
            newRecipes.add(new CarpenterRecipe(carpenterRecipe.getPackagingTime(), carpenterRecipe.getFluidResource(), carpenterRecipe.getBox(), this.recreateRecipe(gridRecipe)));
            carpenterRecipeIterator.remove();
        }
        carpenterRecipes.addAll(newRecipes);
    }

    private ShapedRecipeCustom recreateRecipe(ShapedRecipeCustom recipe) {
        NonNullList recipeInputs = recipe.func_192400_c();
        int width = recipe.getRecipeWidth();
        int height = recipe.getRecipeHeight();
        int root = Math.max(width, height);
        Object[] newRecipeInputs = new Object[root * root];
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                Ingredient ingredient;
                Ingredient ingredient2 = ingredient = i < recipeInputs.size() ? (Ingredient)recipeInputs.get(i) : null;
                if (ingredient != null && ingredient.func_193365_a().length > 0) {
                    ItemStack itemStack = ingredient.func_193365_a()[0];
                    UniResourceContainer container = this.resourceHandler.getContainer(itemStack);
                    newRecipeInputs[y * root + x] = container != null ? container.name : itemStack;
                }
                ++x;
                ++i;
            }
        }
        RecipeAttributes newRecipeAttributes = RecipeHelper.rawShapeToShape((Object[])newRecipeInputs);
        ShapedRecipeCustom newRecipe = new ShapedRecipeCustom(this.resourceHandler.getMainItemStack(recipe.func_77571_b()), newRecipeAttributes.actualShape);
        newRecipe.setRegistryName(recipe.func_193358_e());
        return newRecipe;
    }

    private void fixCentrifugeRecipes() {
        Set centrifugeRecipes = (Set)Util.getField(CentrifugeRecipeManager.class, (String)"recipes", null, Set.class);
        if (centrifugeRecipes == null) {
            return;
        }
        ArrayList<CentrifugeRecipe> newRecipes = new ArrayList<CentrifugeRecipe>();
        Iterator centrifugeRecipeIterator = centrifugeRecipes.iterator();
        while (centrifugeRecipeIterator.hasNext()) {
            ICentrifugeRecipe centrifugeRecipe = (ICentrifugeRecipe)centrifugeRecipeIterator.next();
            newRecipes.add(new CentrifugeRecipe(centrifugeRecipe.getProcessingTime(), centrifugeRecipe.getInput(), this.correctCentrifugeOutput(centrifugeRecipe.getAllProducts())));
            centrifugeRecipeIterator.remove();
        }
        centrifugeRecipes.addAll(newRecipes);
    }

    @Nonnull
    private Map<ItemStack, Float> correctCentrifugeOutput(@Nonnull Map<ItemStack, Float> outputMap) {
        return outputMap.entrySet().stream().collect(Collectors.toMap(entry -> this.resourceHandler.getMainItemStack((ItemStack)entry.getKey()), Map.Entry::getValue));
    }

    private void fixSqueezerRecipes() {
        ItemStackMap containerRecipes = (ItemStackMap)Util.getField(SqueezerRecipeManager.class, (String)"containerRecipes", null, ItemStackMap.class);
        if (containerRecipes == null) {
            return;
        }
        ItemStackMap newContainerRecipes = new ItemStackMap();
        Iterator squeezerRecipeIterator = containerRecipes.values().iterator();
        while (squeezerRecipeIterator.hasNext()) {
            ISqueezerContainerRecipe squeezerRecipe = (ISqueezerContainerRecipe)squeezerRecipeIterator.next();
            newContainerRecipes.put((Object)squeezerRecipe.getEmptyContainer(), (Object)new SqueezerContainerRecipe(squeezerRecipe.getEmptyContainer(), squeezerRecipe.getProcessingTime(), this.resourceHandler.getMainItemStack(squeezerRecipe.getRemnants()), squeezerRecipe.getRemnantsChance()));
            squeezerRecipeIterator.remove();
        }
        containerRecipes.putAll((Map)newContainerRecipes);
    }
}

