/*
 * Decompiled with CFR 0.152.
 */
package appeng.util.inv;

import appeng.util.helpers.ItemHandlerUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WrapperRangeItemHandler
implements IItemHandlerModifiable {
    private final IItemHandler compose;
    private final int minSlot;
    private final int maxSlot;

    public WrapperRangeItemHandler(IItemHandler compose, int minSlot, int maxSlotExclusive) {
        this.compose = compose;
        this.minSlot = minSlot;
        this.maxSlot = maxSlotExclusive;
    }

    public int getSlots() {
        return this.maxSlot - this.minSlot;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getStackInSlot(slot + this.minSlot);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.insertItem(slot + this.minSlot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.checkSlot(slot)) {
            return this.compose.extractItem(slot + this.minSlot, amount, simulate);
        }
        return ItemStack.field_190927_a;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.checkSlot(slot)) {
            ItemHandlerUtil.setStackInSlot(this.compose, slot + this.minSlot, stack);
        }
    }

    public int getSlotLimit(int slot) {
        if (this.checkSlot(slot)) {
            return this.compose.getSlotLimit(slot + this.minSlot);
        }
        return 0;
    }

    private boolean checkSlot(int localSlot) {
        return localSlot + this.minSlot < this.maxSlot;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (this.checkSlot(slot)) {
            return this.compose.isItemValid(slot + this.minSlot, stack);
        }
        return false;
    }
}

