/*
 * Decompiled with CFR 0.152.
 */
package thut.tech.common.blocks.lift;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.ThutBlocks;
import thut.api.network.PacketHandler;
import thut.lib.CompatWrapper;
import thut.tech.common.TechCore;
import thut.tech.common.blocks.lift.TileEntityLiftAccess;
import thut.tech.common.items.ItemLinker;

public class BlockLift
extends Block
implements ITileEntityProvider {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final PropertyBool CALLED = PropertyBool.func_177716_a((String)"called");
    public static final PropertyBool CURRENT = PropertyBool.func_177716_a((String)"current");

    public static void init() {
        ThutBlocks.lift = (Block)new BlockLift().setRegistryName("thuttech", "lift");
    }

    protected BlockLift() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149663_c("lift");
        this.func_149647_a((CreativeTabs)TechCore.tabThut);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.CONTROLLER)).func_177226_a((IProperty)CALLED, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)CURRENT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, CALLED, CURRENT});
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityLiftAccess();
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.func_176203_a(metadata).func_177229_b(VARIANT) == EnumType.LIFT) {
            return null;
        }
        return new TileEntityLiftAccess();
    }

    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(VARIANT) == EnumType.LIFT ? 0 : 1;
    }

    public EnumFacing getFacingfromEntity(EntityLiving e) {
        EnumFacing side = null;
        double angle = e.field_70177_z % 360.0f;
        if (angle > 315.0 || angle <= 45.0) {
            return EnumFacing.SOUTH;
        }
        if (angle > 45.0 && angle <= 135.0) {
            return EnumFacing.WEST;
        }
        if (angle > 135.0 && angle <= 225.0) {
            return EnumFacing.NORTH;
        }
        if (angle > 225.0 && angle <= 315.0) {
            return EnumFacing.EAST;
        }
        return side;
    }

    public int func_176201_c(IBlockState state) {
        if (state.func_177230_c() != this) {
            return state.func_177230_c().func_176201_c(state);
        }
        int ret = ((EnumType)((Object)state.func_177229_b(VARIANT))).ordinal();
        if (((Boolean)state.func_177229_b((IProperty)CALLED)).booleanValue()) {
            ret += 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)CURRENT)).booleanValue()) {
            ret += 8;
        }
        return ret;
    }

    public IBlockState func_176203_a(int meta) {
        int typeMeta = meta & 3;
        boolean called = (meta / 4 & 1) > 0;
        boolean current = (meta / 8 & 1) > 0;
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.values()[typeMeta])).func_177226_a((IProperty)CALLED, (Comparable)Boolean.valueOf(called)).func_177226_a((IProperty)CURRENT, (Comparable)Boolean.valueOf(current));
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> par3List) {
        for (int j = 0; j < 2; ++j) {
            par3List.add((Object)new ItemStack(Item.func_150898_a((Block)this), 1, j));
        }
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)CURRENT) != false ? 15 : 0;
    }

    public boolean hasTileEntity(int metadata) {
        return metadata == 1;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean linkerOrStick;
        ItemStack heldItem = playerIn.func_184586_b(hand);
        boolean bl = linkerOrStick = CompatWrapper.isValid((ItemStack)heldItem) && (heldItem.func_77973_b().func_77658_a().toLowerCase().contains("wrench") || heldItem.func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || heldItem.func_77973_b() instanceof ItemLinker || heldItem.func_77973_b() == Items.field_151055_y);
        if (linkerOrStick && playerIn.func_70093_af()) {
            return false;
        }
        if (CompatWrapper.isValid((ItemStack)heldItem) && !linkerOrStick && side == EnumFacing.DOWN) {
            Block b = Block.func_149634_a((Item)heldItem.func_77973_b());
            if (b != null && state.func_177229_b(VARIANT) == EnumType.CONTROLLER) {
                IBlockState newState = CompatWrapper.getBlockStateFromMeta((Block)b, (int)heldItem.func_77952_i());
                TileEntityLiftAccess te = (TileEntityLiftAccess)worldIn.func_175625_s(pos);
                te.copiedState = newState;
                if (!te.func_145831_w().field_72995_K) {
                    PacketHandler.sendTileUpdate((TileEntity)te);
                }
                return true;
            }
            return false;
        }
        if (state.func_177229_b(VARIANT) == EnumType.LIFT) {
            return false;
        }
        if (state.func_177229_b(VARIANT) == EnumType.CONTROLLER) {
            TileEntityLiftAccess te = (TileEntityLiftAccess)worldIn.func_175625_s(pos);
            if (te != null && (!te.isSideOn(side) || CompatWrapper.isValid((ItemStack)heldItem) && heldItem.func_77973_b() == Items.field_151055_y)) {
                if (linkerOrStick) {
                    if (!worldIn.field_72995_K) {
                        te.setSide(side, !te.isSideOn(side));
                        if (worldIn instanceof WorldServer) {
                            te.sendUpdate((EntityPlayerMP)playerIn);
                        }
                    }
                    return true;
                }
            } else {
                if (te != null && te.isSideOn(side)) {
                    if (CompatWrapper.isValid((ItemStack)heldItem) && (heldItem.func_77973_b().func_77658_a().toLowerCase().contains("wrench") || heldItem.func_77973_b().func_77658_a().toLowerCase().contains("screwdriver") || heldItem.func_77973_b() instanceof ItemLinker)) {
                        if (!(worldIn.field_72995_K || te.editFace[side.ordinal()] || te.floorDisplay[side.ordinal()])) {
                            te.setSidePage(side, (te.getSidePage(side) + 1) % 8);
                            if (playerIn instanceof EntityPlayerMP) {
                                te.sendUpdate((EntityPlayerMP)playerIn);
                            }
                            PacketHandler.sendTileUpdate((TileEntity)te);
                        }
                        return true;
                    }
                    return te.doButtonClick((EntityLivingBase)playerIn, side, hitX, hitY, hitZ);
                }
                if (te == null) {
                    new Exception().printStackTrace();
                }
            }
        }
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(meta);
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityLiftAccess tile = (TileEntityLiftAccess)worldIn.func_175625_s(pos);
        if (tile != null && tile.copiedState != null && tile.func_145831_w().field_72995_K) {
            return tile.copiedState;
        }
        return state;
    }

    public static enum EnumType implements IStringSerializable
    {
        LIFT("lift"),
        CONTROLLER("liftcontroller");

        private final String name;

        private EnumType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

