/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import thut.api.maths.Vector3;
import thut.core.client.render.particle.IParticle;

public class ParticleHandler {
    private static ParticleHandler instance;
    List<ParticlePacket> particles = Lists.newArrayList();

    public static ParticleHandler Instance() {
        if (instance == null) {
            instance = new ParticleHandler();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addParticle(Vector3 location, IParticle particle) {
        if (particle == null || location == null || Minecraft.func_71410_x().field_71474_y.field_74362_aa > 1) {
            return;
        }
        List<ParticlePacket> list = this.particles;
        synchronized (list) {
            this.particles.add(new ParticlePacket(location.copy(), particle));
        }
    }

    public void clear() {
        this.particles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorldPost(EntityViewRenderEvent.RenderFogEvent event) {
        try {
            List<ParticlePacket> list = this.particles;
            synchronized (list) {
                int i;
                GL11.glPushMatrix();
                ArrayList list2 = Lists.newArrayList();
                for (i = 0; i < this.particles.size(); ++i) {
                    ParticlePacket packet = this.particles.get(i);
                    IParticle particle = packet.particle;
                    Vector3 target = packet.location;
                    if (particle.getDuration() < 0) {
                        packet.kill();
                        list2.add(packet);
                        continue;
                    }
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    Vector3 source = Vector3.getNewVector().set(player.field_70142_S, player.field_70137_T, player.field_70136_U);
                    GL11.glPushMatrix();
                    source.set(target.subtract(source));
                    GL11.glTranslated((double)source.x, (double)source.y, (double)source.z);
                    double d0 = (-player.field_70165_t + player.field_70142_S) * event.getRenderPartialTicks();
                    double d1 = (-player.field_70163_u + player.field_70137_T) * event.getRenderPartialTicks();
                    double d2 = (-player.field_70161_v + player.field_70136_U) * event.getRenderPartialTicks();
                    source.set(d0, d1, d2);
                    GL11.glTranslated((double)source.x, (double)source.y, (double)source.z);
                    particle.render(event.getRenderPartialTicks());
                    GL11.glPopMatrix();
                    if (particle.lastTick() != event.getEntity().func_130014_f_().func_82737_E()) {
                        particle.setDuration(particle.getDuration() - 1);
                        particle.setLastTick(event.getEntity().func_130014_f_().func_82737_E());
                    }
                    if (particle.getDuration() >= 0) continue;
                    packet.kill();
                    list2.add(packet);
                }
                GL11.glPopMatrix();
                for (i = 0; i < list2.size(); ++i) {
                    this.particles.remove(list2.get(i));
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void WorldUnloadEvent(WorldEvent.Unload evt) {
        if (evt.getWorld().field_73011_w.getDimension() == 0 && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.clear();
        }
    }

    private static class ParticlePacket {
        final Vector3 location;
        final IParticle particle;

        public ParticlePacket(Vector3 v, IParticle p) {
            this.location = v;
            this.particle = p;
        }

        public void kill() {
            this.particle.kill();
        }
    }
}

