/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import thut.core.client.render.model.IAnimationChanger;
import thut.core.client.render.tabula.components.Animation;

public class AnimationRandomizer
implements IAnimationChanger {
    Map<Integer, AnimationSet> running = Maps.newHashMap();
    Map<String, List<RandomAnimation>> sets = Maps.newHashMap();
    Map<String, Set<LoadedAnimSet>> loadedSets = Maps.newHashMap();

    public AnimationRandomizer(Node node) {
        NodeList parts = node.getChildNodes();
        for (int i = 0; i < parts.getLength(); ++i) {
            Node part = parts.item(i);
            if (part.getAttributes() == null) continue;
            String parent = part.getAttributes().getNamedItem("parent").getNodeValue();
            String name = part.getAttributes().getNamedItem("name").getNodeValue();
            double chance = Double.parseDouble(part.getAttributes().getNamedItem("chance").getNodeValue());
            LoadedAnimSet set = new LoadedAnimSet();
            set.chance = chance;
            set.name = name;
            HashSet sets = this.loadedSets.get(parent);
            if (sets == null) {
                sets = Sets.newHashSet();
                this.loadedSets.put(parent, sets);
            }
            sets.add((LoadedAnimSet)set);
        }
    }

    private void addAnimationSet(Animation animation, double chance, String parent) {
        ArrayList anims = this.sets.get(parent);
        if (anims == null) {
            anims = Lists.newArrayList();
            this.sets.put(parent, anims);
        }
        anims.add(new RandomAnimation(animation, chance));
    }

    @Override
    public int getColourForPart(String partIdentifier, Entity entity, int default_) {
        return default_;
    }

    public void init(Set<Animation> existingAnimations) {
        HashSet animations = Sets.newHashSet();
        for (Animation existing : existingAnimations) {
            if (!this.loadedSets.containsKey(existing.name)) continue;
            animations.add(existing.name);
        }
        for (String s : animations) {
            Set<LoadedAnimSet> set = this.loadedSets.get(s);
            block2: for (LoadedAnimSet loaded : set) {
                for (Animation anim : existingAnimations) {
                    if (!anim.name.equals(loaded.name)) continue;
                    this.addAnimationSet(anim, loaded.chance, s);
                    continue block2;
                }
            }
        }
    }

    @Override
    public boolean isPartHidden(String part, Entity entity, boolean default_) {
        return default_;
    }

    @Override
    public String modifyAnimation(EntityLiving entity, float partialTicks, String phase) {
        if (this.running.containsKey(entity.func_145782_y())) {
            AnimationSet anim = this.running.get(entity.func_145782_y());
            phase = anim.anim.name;
            if (anim.set < entity.field_70173_aa) {
                this.running.remove(entity.func_145782_y());
            }
            return phase;
        }
        if (this.sets.containsKey(phase)) {
            List<RandomAnimation> set = this.sets.get(phase);
            int rand = entity.func_70681_au().nextInt(set.size());
            RandomAnimation anim = set.get(rand);
            if (Math.random() < anim.chance) {
                AnimationSet aSet = new AnimationSet(anim);
                aSet.set = entity.field_70173_aa + aSet.anim.duration;
                this.running.put(entity.func_145782_y(), aSet);
                phase = anim.name;
            }
        }
        return phase;
    }

    private static class RandomAnimation {
        final String name;
        double chance = 0.005;
        int duration = 0;

        public RandomAnimation(Animation animation, double chance) {
            this.chance = chance;
            this.name = animation.name;
            this.duration = animation.getLength();
        }
    }

    private static class LoadedAnimSet {
        String name;
        double chance;

        private LoadedAnimSet() {
        }
    }

    private static class AnimationSet {
        final RandomAnimation anim;
        int set;

        public AnimationSet(RandomAnimation anim) {
            this.anim = anim;
        }
    }
}

