/*
 * Decompiled with CFR 0.152.
 */
package thut.api.terrain;

import java.util.HashMap;
import java.util.Locale;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.village.Village;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeType;
import thut.lib.CompatWrapper;

public class BiomeDatabase {
    public static HashMap<Biome, BiomeDictionary.Type[]> biomeTypes = new HashMap();
    private static final int INDEX = 17;

    public static boolean contains(Biome b, BiomeDictionary.Type type) {
        return CompatWrapper.isOfType(b, type);
    }

    public static BiomeType getBiome(Biome b) {
        if (b != null && BiomeDatabase.getBiomeName(b).toLowerCase(Locale.ENGLISH).contains("flower")) {
            return BiomeType.FLOWER;
        }
        return BiomeType.NONE;
    }

    public static Biome getBiome(String name) {
        return (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation(name));
    }

    public static String getBiome(World world, Vector3 v, boolean checkIndandVillage) {
        Village village;
        String ret = "";
        if (checkIndandVillage && (village = world.field_72982_D.func_176056_a(new BlockPos(MathHelper.func_76141_d((float)v.intX()), MathHelper.func_76141_d((float)v.intY()), MathHelper.func_76141_d((float)v.intZ())), 2)) != null) {
            return "village";
        }
        Biome biome = v.getBiome(world);
        ret = BiomeDatabase.getBiome((Biome)biome).name;
        return ret;
    }

    public static String getReadableNameFromType(int type) {
        return BiomeType.getType((int)type).readableName;
    }

    public static String getBiomeName(Biome biome) {
        return (String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (int)17);
    }
}

