/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.blockentity;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thut.api.entity.blockentity.BlockEntityInteractHandler;
import thut.api.entity.blockentity.BlockEntityUpdater;
import thut.api.entity.blockentity.BlockEntityWorld;
import thut.api.entity.blockentity.IBlockEntity;
import thut.core.common.ThutCore;

public abstract class BlockEntityBase
extends EntityLivingBase
implements IEntityAdditionalSpawnData,
IBlockEntity {
    public static int ACCELERATIONTICKS = 20;
    public BlockPos boundMin = BlockPos.field_177992_a;
    public BlockPos boundMax = BlockPos.field_177992_a;
    private BlockEntityWorld fake_world;
    private boolean shouldRevert = true;
    public double speedUp = 0.5;
    public double speedDown = -0.5;
    public double speedHoriz = 0.5;
    public double acceleration = 0.05;
    public boolean toMoveY = false;
    public boolean toMoveX = false;
    public boolean toMoveZ = false;
    public boolean hasPassenger = false;
    int n = 0;
    boolean first = true;
    Random r = new Random();
    public UUID owner;
    public List<AxisAlignedBB> blockBoxes = Lists.newArrayList();
    public IBlockState[][][] blocks = null;
    public TileEntity[][][] tiles = null;
    BlockEntityUpdater collider;
    BlockEntityInteractHandler interacter;

    public BlockEntityBase(World par1World) {
        super(par1World);
        this.field_70158_ak = true;
        this.field_70172_ad = 0;
        this.field_70178_ae = true;
    }

    @Override
    public BlockEntityWorld getFakeWorld() {
        if (this.fake_world == null) {
            this.fake_world = new BlockEntityWorld(this, this.field_70170_p);
        }
        return this.fake_world;
    }

    public BlockEntityBase(World world, double x, double y, double z) {
        this(world);
        this.func_70107_b(x, y, z);
        this.r.setSeed(100L);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void func_70653_a(Entity entityIn, float strenght, double xRatio, double zRatio) {
    }

    protected double getSpeed(double pos, double destPos, double speed, double speedPos, double speedNeg) {
        if (!this.func_130014_f_().func_175697_a(this.func_180425_c(), 8)) {
            return 0.0;
        }
        double ds = speed;
        double dp = destPos - pos;
        if (dp > 0.0) {
            boolean tooFast;
            boolean bl = tooFast = pos + ds * (double)(ACCELERATIONTICKS + 1) > destPos;
            if (!tooFast) {
                ds = Math.min(speedPos, ds + this.acceleration * speedPos);
            } else {
                while (ds >= 0.0 && tooFast) {
                    tooFast = pos + (ds -= this.acceleration * speedPos / 10.0) * (double)(ACCELERATIONTICKS + 1) > destPos;
                }
            }
            return ds;
        }
        if (dp < 0.0) {
            boolean tooFast;
            speedNeg = Math.abs(speedNeg);
            boolean bl = tooFast = pos + ds * (double)(ACCELERATIONTICKS + 1) < destPos;
            if (!tooFast) {
                ds = Math.max(-speedNeg, ds - this.acceleration * speedNeg);
            } else {
                while (ds <= 0.0 && tooFast) {
                    tooFast = pos + (ds += this.acceleration * speedNeg / 10.0) * (double)(ACCELERATIONTICKS + 1) < destPos;
                }
            }
            return ds;
        }
        return 0.0;
    }

    protected abstract void accelerate();

    public void func_70108_f(Entity entity) {
        if (this.collider == null) {
            this.collider = new BlockEntityUpdater(this);
            this.collider.onSetPosition();
        }
        try {
            this.collider.applyEntityCollision(entity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void checkCollision() {
        int zMax;
        int xMax;
        int zMin;
        int xMin = this.boundMin.func_177958_n();
        List list = this.field_70170_p.func_72839_b((Entity)this, new AxisAlignedBB(this.field_70165_t + (double)(xMin - 1), this.field_70163_u, this.field_70161_v + (double)((zMin = this.boundMin.func_177952_p()) - 1), this.field_70165_t + (double)(xMax = this.boundMax.func_177958_n()) + 1.0, this.field_70163_u + 64.0, this.field_70161_v + (double)(zMax = this.boundMax.func_177952_p()) + 1.0));
        if (list != null && !list.isEmpty()) {
            if (list.size() == 1 && this.func_184182_bu() != null && !this.func_184182_bu().isEmpty()) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                this.func_70108_f(entity);
                if (!(entity instanceof EntityPlayerMP) || !entity.func_174813_aQ().func_186662_g(2.0).func_72326_a(this.func_174813_aQ())) continue;
                this.hasPassenger = true;
            }
        }
    }

    protected abstract boolean checkAccelerationConditions();

    protected abstract void doMotion();

    public void func_174829_m() {
        BlockPos min = this.getMin();
        BlockPos max = this.getMax();
        float xDiff = (float)(max.func_177958_n() - min.func_177958_n()) / 2.0f;
        float zDiff = (float)(max.func_177952_p() - min.func_177952_p()) / 2.0f;
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        this.field_70165_t = xDiff % 1.0f != 0.0f ? axisalignedbb.field_72340_a + (double)xDiff : (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
        this.field_70163_u = axisalignedbb.field_72338_b;
        this.field_70161_v = zDiff % 1.0f != 0.0f ? axisalignedbb.field_72339_c + (double)zDiff : (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public AxisAlignedBB getBoundingBox() {
        return null;
    }

    public boolean getCanSpawnHere() {
        return false;
    }

    protected abstract BlockEntityInteractHandler createInteractHandler();

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (this.interacter == null) {
            this.interacter = this.createInteractHandler();
        }
        try {
            return this.interacter.applyPlayerInteraction(player, vec, player.func_184586_b(hand), hand);
        }
        catch (Exception e) {
            ThutCore.logger.log(Level.SEVERE, "Error handling interactions for " + this, e);
            return super.func_184199_a(player, vec, hand);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.interacter == null) {
            this.interacter = this.createInteractHandler();
        }
        return this.interacter.processInitialInteract(player, player.func_184586_b(hand), hand);
    }

    public boolean func_70687_e(PotionEffect par1PotionEffect) {
        return false;
    }

    protected abstract void preColliderTick();

    protected abstract void onGridAlign();

    public void func_70071_h_() {
        if (ForgeHooks.onLivingUpdate((EntityLivingBase)this)) {
            return;
        }
        if (this.collider == null) {
            this.collider = new BlockEntityUpdater(this);
            this.collider.onSetPosition();
        }
        this.preColliderTick();
        this.field_70167_r = this.field_70163_u;
        this.field_70169_q = this.field_70165_t;
        this.field_70166_s = this.field_70161_v;
        this.collider.onUpdate();
        this.accelerate();
        int dy = (int)(this.field_70181_x * 16.0);
        int dx = (int)(this.field_70159_w * 16.0);
        int dz = (int)(this.field_70179_y * 16.0);
        if (this.toMoveY || this.toMoveX || this.toMoveZ) {
            this.doMotion();
        } else if (dx == dy && dy == dz && dz == 0 && !this.field_70170_p.field_72995_K) {
            boolean update;
            BlockPos pos = this.func_180425_c();
            boolean bl = update = this.field_70165_t != (double)pos.func_177958_n() + 0.5 || this.field_70163_u != (double)Math.round(this.field_70163_u) || this.field_70161_v != (double)pos.func_177952_p() + 0.5;
            if (update) {
                this.onGridAlign();
            }
        }
        this.checkCollision();
    }

    public void readBlocks(NBTTagCompound nbt) {
        if (nbt.func_74764_b("Blocks")) {
            NBTTagCompound blockTag = nbt.func_74775_l("Blocks");
            int sizeX = blockTag.func_74762_e("BlocksLengthX");
            int sizeZ = blockTag.func_74762_e("BlocksLengthZ");
            int sizeY = blockTag.func_74762_e("BlocksLengthY");
            if (sizeX == 0 || sizeZ == 0) {
                sizeX = sizeZ = nbt.func_74762_e("BlocksLength");
            }
            if (sizeY == 0) {
                sizeY = 1;
            }
            int version = blockTag.func_74762_e("v");
            this.blocks = new IBlockState[sizeX][sizeY][sizeZ];
            this.tiles = new TileEntity[sizeX][sizeY][sizeZ];
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        IBlockState state;
                        int meta;
                        Block b;
                        int n = -1;
                        if (blockTag.func_74764_b("I" + i + "," + j)) {
                            n = blockTag.func_74762_e("I" + i + "," + j);
                        } else if (blockTag.func_74764_b("I" + i + "," + k + "," + j)) {
                            n = blockTag.func_74762_e("I" + i + "," + k + "," + j);
                        }
                        if (n == -1) continue;
                        if (version == 0) {
                            b = Block.func_149634_a((Item)Item.func_150899_d((int)n));
                            meta = blockTag.func_74762_e("M" + i + "," + k + "," + j);
                            state = b.func_176203_a(meta);
                        } else {
                            b = Block.func_149729_e((int)n);
                            meta = blockTag.func_74762_e("M" + i + "," + k + "," + j);
                            state = b.func_176203_a(meta);
                        }
                        this.blocks[i][k][j] = state;
                        if (!blockTag.func_74764_b("T" + i + "," + k + "," + j)) continue;
                        try {
                            NBTTagCompound tag = blockTag.func_74775_l("T" + i + "," + k + "," + j);
                            this.tiles[i][k][j] = IBlockEntity.BlockEntityFormer.makeTile(tag);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            this.setBlocks(this.blocks);
            this.setTiles(this.tiles);
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("bounds")) {
            NBTTagCompound bounds = nbt.func_74775_l("bounds");
            this.boundMin = new BlockPos(bounds.func_74769_h("minx"), bounds.func_74769_h("miny"), bounds.func_74769_h("minz"));
            this.boundMax = new BlockPos(bounds.func_74769_h("maxx"), bounds.func_74769_h("maxy"), bounds.func_74769_h("maxz"));
        }
        this.readBlocks(nbt);
    }

    public void readSpawnData(ByteBuf data) {
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        try {
            tag = buff.func_150793_b();
            this.func_70037_a(tag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_70106_y() {
        if (!this.func_130014_f_().field_72995_K && !this.field_70128_L && this.field_70175_ag && this.shouldRevert) {
            IBlockEntity.BlockEntityFormer.RevertEntity(this);
        }
        super.func_70106_y();
    }

    public void func_184174_b(boolean dropWhenDead) {
        this.shouldRevert = dropWhenDead;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
        if (this.collider != null) {
            this.collider.onSetPosition();
        }
    }

    public void writeBlocks(NBTTagCompound nbt) {
        if (this.blocks != null) {
            NBTTagCompound blocksTag = new NBTTagCompound();
            blocksTag.func_74768_a("BlocksLengthX", this.blocks.length);
            blocksTag.func_74768_a("BlocksLengthY", this.blocks[0].length);
            blocksTag.func_74768_a("BlocksLengthZ", this.blocks[0][0].length);
            blocksTag.func_74768_a("v", 1);
            int sizeX = this.blocks.length;
            int sizeY = this.blocks[0].length;
            int sizeZ = this.blocks[0][0].length;
            for (int i = 0; i < sizeX; ++i) {
                for (int k = 0; k < sizeY; ++k) {
                    for (int j = 0; j < sizeZ; ++j) {
                        IBlockState b = this.blocks[i][k][j];
                        if (b == null) continue;
                        blocksTag.func_74768_a("I" + i + "," + k + "," + j, Block.func_149682_b((Block)b.func_177230_c()));
                        blocksTag.func_74768_a("M" + i + "," + k + "," + j, b.func_177230_c().func_176201_c(b));
                        try {
                            if (this.tiles[i][k][j] == null) continue;
                            NBTTagCompound tag = new NBTTagCompound();
                            tag = this.tiles[i][k][j].func_189515_b(tag);
                            blocksTag.func_74782_a("T" + i + "," + k + "," + j, (NBTBase)tag);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            nbt.func_74782_a("Blocks", (NBTBase)blocksTag);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        NBTTagCompound vector = new NBTTagCompound();
        vector.func_74780_a("minx", (double)this.boundMin.func_177958_n());
        vector.func_74780_a("miny", (double)this.boundMin.func_177956_o());
        vector.func_74780_a("minz", (double)this.boundMin.func_177952_p());
        vector.func_74780_a("maxx", (double)this.boundMax.func_177958_n());
        vector.func_74780_a("maxy", (double)this.boundMax.func_177956_o());
        vector.func_74780_a("maxz", (double)this.boundMax.func_177952_p());
        nbt.func_74782_a("bounds", (NBTBase)vector);
        try {
            this.writeBlocks(nbt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeSpawnData(ByteBuf data) {
        PacketBuffer buff = new PacketBuffer(data);
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        buff.func_150786_a(tag);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return true;
    }

    public boolean func_184186_bw() {
        return true;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Lists.newArrayList();
    }

    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
    }

    public ItemStack func_184586_b(EnumHand hand) {
        return ItemStack.field_190927_a;
    }

    public void func_184611_a(EnumHand hand, @Nullable ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.LEFT;
    }

    @Override
    public void setBlocks(IBlockState[][][] blocks) {
        this.blocks = blocks;
    }

    @Override
    public IBlockState[][][] getBlocks() {
        return this.blocks;
    }

    @Override
    public void setTiles(TileEntity[][][] tiles) {
        this.tiles = tiles;
    }

    @Override
    public TileEntity[][][] getTiles() {
        return this.tiles;
    }

    @Override
    public BlockPos getMin() {
        return this.boundMin;
    }

    @Override
    public BlockPos getMax() {
        return this.boundMax;
    }

    @Override
    public void setMin(BlockPos pos) {
        this.boundMin = pos;
    }

    @Override
    public void setMax(BlockPos pos) {
        this.boundMax = pos;
    }

    @Override
    public void setFakeWorld(BlockEntityWorld world) {
        this.fake_world = world;
    }
}

