/*
 * Decompiled with CFR 0.152.
 */
package thut.api.entity.ai;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import thut.api.TickHandler;
import thut.api.entity.ai.IAIMob;
import thut.api.entity.ai.IAIRunnable;
import thut.api.entity.ai.ILogicRunnable;
import thut.api.entity.genetics.IMobGenetics;
import thut.core.common.ThutCore;

public class AIThreadManager {
    public static Logger logger;
    private static Queue<AIStuff>[] aiStuffLists;
    public static final HashMap<Integer, Vector<Object>> worldPlayers;
    public static final ConcurrentHashMap<Integer, Vector<Entity>> worldEntities;
    public static final Comparator<IAIRunnable> aiComparator;

    private static boolean canRun(IAIRunnable task, ArrayList<IAIRunnable> tasks) {
        int prior = task.getPriority();
        int mutex = task.getMutex();
        for (int i = 0; i < tasks.size(); ++i) {
            IAIRunnable ai = tasks.get(i);
            if (ai.getPriority() >= prior || (mutex & ai.getMutex()) == 0 || !ai.shouldRun()) continue;
            return false;
        }
        return task.shouldRun();
    }

    public static void clear() {
        if (aiStuffLists != null) {
            for (Queue<AIStuff> v : aiStuffLists) {
                v.clear();
            }
        }
        worldPlayers.clear();
        TickHandler.getInstance().worldCaches.clear();
    }

    public static void scheduleAITick(AIStuff ai) {
        if (!ThutCore.instance.config.multithreadedAI) {
            return;
        }
        int id = ai.entity.func_145782_y() % AIThread.threadCount;
        AIThread thread = AIThread.threads.get(id);
        thread.aiStuff.add(ai);
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.WorldTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            Vector<Object> players = worldPlayers.get(evt.world.field_73011_w.getDimension());
            if (players == null) {
                players = new Vector();
            }
            players.clear();
            players.addAll(evt.world.field_73010_i);
            worldPlayers.put(evt.world.field_73011_w.getDimension(), players);
            Vector<Object> entities = worldEntities.get(evt.world.field_73011_w.getDimension());
            if (entities == null) {
                entities = new Vector();
            }
            entities.clear();
            entities.addAll(evt.world.field_72996_f);
            worldEntities.put(evt.world.field_73011_w.getDimension(), entities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tickEventServer(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            for (AIThread thread : AIThread.threads.values()) {
                try {
                    Object object = thread.lock;
                    synchronized (object) {
                        thread.lock.notify();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error ticking AI stuff", e);
                }
            }
        }
    }

    @SubscribeEvent
    public void LivingUpdate(LivingEvent.LivingUpdateEvent event) {
        IAIMob mob = null;
        AIStuff ai = null;
        if (event.getEntity() instanceof IAIMob) {
            mob = (IAIMob)event.getEntity();
            ai = mob.getAI();
        } else if (event.getEntity().hasCapability(IAIMob.THUTMOBAI, null)) {
            mob = (IAIMob)event.getEntity().getCapability(IAIMob.THUTMOBAI, null);
            ai = mob.getAI();
        }
        if (mob != null && mob.vanillaWrapped()) {
            if (event.getEntity().field_70170_p.field_72995_K) {
                for (ILogicRunnable logic : ai.aiLogic) {
                    logic.doServerTick(event.getEntity().func_130014_f_());
                }
            }
            return;
        }
        IMobGenetics genes = (IMobGenetics)event.getEntity().getCapability(IMobGenetics.GENETICS_CAP, null);
        if (genes != null) {
            genes.onUpdateTick(event.getEntityLiving());
        }
        if (mob == null || mob.selfManaged() || ai == null) {
            return;
        }
        for (ILogicRunnable logic : ai.aiLogic) {
            logic.doServerTick(event.getEntity().func_130014_f_());
        }
        if (!event.getEntity().func_130014_f_().field_72995_K) {
            this.updateEntityActionState((EntityLiving)event.getEntityLiving(), ai);
        }
    }

    protected void updateEntityActionState(EntityLiving mob, AIStuff ai) {
        mob.func_130014_f_().field_72984_F.func_76320_a("custom_ai");
        ai.runServerThreadTasks(mob.func_130014_f_());
        AIThreadManager.scheduleAITick(ai);
        mob.func_130014_f_().field_72984_F.func_76319_b();
    }

    static /* synthetic */ Queue[] access$102(Queue[] x0) {
        aiStuffLists = x0;
        return x0;
    }

    static {
        worldPlayers = new HashMap();
        worldEntities = new ConcurrentHashMap();
        aiComparator = new Comparator<IAIRunnable>(){

            @Override
            public int compare(IAIRunnable o1, IAIRunnable o2) {
                return o1.getPriority() - o2.getPriority();
            }
        };
    }

    public static class AIThread
    extends Thread {
        public static int threadCount = 1;
        public static HashMap<Integer, AIThread> threads = Maps.newHashMap();
        public final Queue<AIStuff> aiStuff;
        public final Object lock;
        final int id;

        public static void createThreads() {
            threadCount = Math.min(threadCount, Runtime.getRuntime().availableProcessors());
            AIThreadManager.access$102(new Queue[threadCount]);
            logger.log(Level.INFO, "Creating and starting " + threadCount + " Mob AI Threads.");
            for (int i = 0; i < threadCount; ++i) {
                ConcurrentLinkedQueue set = Queues.newConcurrentLinkedQueue();
                AIThread thread = new AIThread(i, set, new Object());
                aiStuffLists[i] = set;
                thread.setPriority(8);
                thread.start();
            }
        }

        public AIThread(final int number, final Queue<AIStuff> aiStuff, final Object lock) {
            super((ThreadGroup)SidedThreadGroups.SERVER, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread thread = Thread.currentThread();
                    if (!(thread instanceof AIThread)) {
                        new ClassCastException("wrong thread type").printStackTrace();
                        return;
                    }
                    int id = number;
                    logger.log(Level.INFO, "This is Thread " + id);
                    while (true) {
                        Object object = lock;
                        synchronized (object) {
                            try {
                                lock.wait();
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, "Error waiting on lock", e);
                            }
                        }
                        object = aiStuff;
                        synchronized (object) {
                            while (!aiStuff.isEmpty()) {
                                ((AIStuff)aiStuff.remove()).tick();
                            }
                        }
                    }
                }
            });
            this.lock = lock;
            this.id = number;
            this.aiStuff = aiStuff;
            this.setName("Netty Server IO - Mob AI Thread-" + this.id);
            threads.put(this.id, this);
        }
    }

    public static class AIStuff {
        public static int tickRate = 1;
        public final EntityLiving entity;
        public final ArrayList<IAIRunnable> aiTasks = new ArrayList();
        public final ArrayList<ILogicRunnable> aiLogic = new ArrayList();

        public AIStuff(EntityLiving entity_) {
            this.entity = entity_;
        }

        public void addAILogic(ILogicRunnable logic) {
            this.aiLogic.add(logic);
        }

        public void addAITask(IAIRunnable task) {
            this.aiTasks.add(task);
        }

        public void runServerThreadTasks(World world) {
            if (!ThutCore.instance.config.multithreadedAI) {
                if (world.func_82737_E() % (long)tickRate != 0L) {
                    return;
                }
                this.tick();
            }
            for (IAIRunnable ai : this.aiTasks) {
                ai.doMainThreadTick(world);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void tick() {
            ArrayList<Object> list;
            ArrayList<IAIRunnable> arrayList = this.aiTasks;
            synchronized (arrayList) {
                list = this.aiTasks;
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        IAIRunnable ai = (IAIRunnable)list.get(i);
                        try {
                            if (AIThreadManager.canRun(ai, list)) {
                                ai.run();
                                continue;
                            }
                            ai.reset();
                            continue;
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "error checking task " + ai, e);
                        }
                    }
                }
            }
            list = this.aiLogic;
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    ILogicRunnable runnable = (ILogicRunnable)list.get(i);
                    try {
                        runnable.doLogic();
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "error executing " + runnable, e);
                    }
                }
            }
        }
    }
}

