/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.plug;

import buildcraft.api.BCModules;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacade;
import buildcraft.api.facades.IFacadePhasedState;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.misc.MathUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.silicon.BCSiliconItems;
import buildcraft.silicon.client.model.key.KeyPlugFacade;
import buildcraft.silicon.plug.FacadeInstance;
import buildcraft.silicon.plug.FacadePhasedState;
import buildcraft.transport.client.model.key.KeyPlugBlocker;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PluggableFacade
extends PipePluggable
implements IFacade {
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[6];
    public static final int SIZE = 2;
    public final FacadeInstance states;
    public final boolean isSideSolid;
    public final BlockFaceShape blockFaceShape;
    public int activeState;

    public PluggableFacade(PluggableDefinition definition, IPipeHolder holder, EnumFacing side, FacadeInstance states) {
        super(definition, holder, side);
        this.states = states;
        this.isSideSolid = states.areAllStatesSolid(side);
        this.blockFaceShape = states.getBlockFaceShape(side);
    }

    public PluggableFacade(PluggableDefinition def, IPipeHolder holder, EnumFacing side, NBTTagCompound nbt) {
        super(def, holder, side);
        NBTTagList tagStates;
        if (nbt.func_74764_b("states") && !nbt.func_74764_b("facade") && (tagStates = nbt.func_150295_c("states", 10)).func_74745_c() > 0) {
            boolean isHollow = tagStates.func_150305_b(0).func_74767_n("isHollow");
            NBTTagCompound tagFacade = new NBTTagCompound();
            tagFacade.func_74782_a("states", (NBTBase)tagStates);
            tagFacade.func_74757_a("isHollow", isHollow);
            nbt.func_74782_a("facade", (NBTBase)tagFacade);
        }
        this.states = FacadeInstance.readFromNbt(nbt.func_74775_l("facade"));
        this.activeState = MathUtil.clamp(nbt.func_74762_e("activeState"), 0, this.states.phasedStates.length - 1);
        this.isSideSolid = this.states.areAllStatesSolid(side);
        this.blockFaceShape = this.states.getBlockFaceShape(side);
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("facade", (NBTBase)this.states.writeToNbt());
        nbt.func_74768_a("activeState", this.activeState);
        return nbt;
    }

    public PluggableFacade(PluggableDefinition def, IPipeHolder holder, EnumFacing side, PacketBuffer buffer) {
        super(def, holder, side);
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc((ByteBuf)buffer);
        this.states = FacadeInstance.readFromBuffer(buf);
        this.isSideSolid = buf.readBoolean();
        this.blockFaceShape = buf.func_179257_a(BlockFaceShape.class);
    }

    @Override
    public void writeCreationPayload(PacketBuffer buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc((ByteBuf)buffer);
        this.states.writeToBuffer(buf);
        buf.writeBoolean(this.isSideSolid);
        buf.writeEnumValue((Enum<?>)this.blockFaceShape);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return BOXES[this.side.func_176745_a()];
    }

    @Override
    public boolean isBlocking() {
        return !this.isHollow();
    }

    @Override
    public boolean canBeConnected() {
        return !this.isHollow();
    }

    @Override
    public boolean isSideSolid() {
        return this.isSideSolid;
    }

    @Override
    public float getExplosionResistance(@Nullable Entity exploder, Explosion explosion) {
        return this.states.phasedStates[this.activeState].stateInfo.state.func_177230_c().func_149638_a(exploder);
    }

    @Override
    public BlockFaceShape getBlockFaceShape() {
        return this.blockFaceShape;
    }

    @Override
    public ItemStack getPickStack() {
        return BCSiliconItems.plugFacade.createItemStack(this.states);
    }

    @Override
    public PluggableModelKey getModelRenderKey(BlockRenderLayer layer) {
        if (this.states.type == FacadeType.Basic) {
            FacadePhasedState facadeState = this.states.phasedStates[this.activeState];
            IBlockState blockState = facadeState.stateInfo.state;
            BlockRenderLayer targetLayer = blockState.func_177230_c().func_180664_k();
            if (targetLayer == BlockRenderLayer.TRANSLUCENT ? layer != targetLayer : layer == BlockRenderLayer.TRANSLUCENT) {
                return null;
            }
            return new KeyPlugFacade(layer, this.side, blockState, this.isHollow());
        }
        if (layer == BlockRenderLayer.CUTOUT && BCModules.TRANSPORT.isLoaded()) {
            return KeyPlugBlocker.create(this.side);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getBlockColor(int tintIndex) {
        FacadePhasedState state = this.states.phasedStates[this.activeState];
        BlockColors colours = Minecraft.func_71410_x().func_184125_al();
        return colours.func_186724_a(state.stateInfo.state, (IBlockAccess)this.holder.getPipeWorld(), this.holder.getPipePos(), tintIndex);
    }

    @Override
    public FacadeType getType() {
        return this.states.getType();
    }

    @Override
    public boolean isHollow() {
        return this.states.isHollow();
    }

    @Override
    public IFacadePhasedState[] getPhasedStates() {
        return this.states.getPhasedStates();
    }

    static {
        double ll = 0.0;
        double lu = 0.125;
        double ul = 0.875;
        double uu = 1.0;
        double min = 0.0;
        double max = 1.0;
        PluggableFacade.BOXES[EnumFacing.DOWN.func_176745_a()] = new AxisAlignedBB(min, ll, min, max, lu, max);
        PluggableFacade.BOXES[EnumFacing.UP.func_176745_a()] = new AxisAlignedBB(min, ul, min, max, uu, max);
        PluggableFacade.BOXES[EnumFacing.NORTH.func_176745_a()] = new AxisAlignedBB(min, min, ll, max, max, lu);
        PluggableFacade.BOXES[EnumFacing.SOUTH.func_176745_a()] = new AxisAlignedBB(min, min, ul, max, max, uu);
        PluggableFacade.BOXES[EnumFacing.WEST.func_176745_a()] = new AxisAlignedBB(ll, min, min, lu, max, max);
        PluggableFacade.BOXES[EnumFacing.EAST.func_176745_a()] = new AxisAlignedBB(ul, min, min, uu, max, max);
    }
}

