/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.search;

import buildcraft.api.core.BCLog;
import buildcraft.lib.misc.search.ISuffixArray;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.profiler.Profiler;

public class SimpleSuffixArray<T>
implements ISuffixArray<T> {
    private static final boolean ADD_IS_GENERATE = true;
    private static final boolean USE_AVL = true;
    private static final boolean SPLIT_WORDS = true;
    private final List<String> tempAddedNames = new ArrayList<String>();
    private final List<T> tempAddedObjects = new ArrayList<T>();
    private int maxLength = 0;
    private final Object2ObjectSortedMap<String, List<T>> suffixArray = new Object2ObjectAVLTreeMap();

    @Override
    public void add(T obj, String name) {
        int end = name.length();
        for (int s = name.length() - 1; s >= 0; --s) {
            char c = name.charAt(s);
            if (c == '\n' || c == ' ') {
                end = s;
                continue;
            }
            String suffix = name.substring(s, end);
            ArrayList<T> list = (ArrayList<T>)this.suffixArray.get((Object)suffix);
            if (list == null) {
                list = new ArrayList<T>();
                this.suffixArray.put((Object)suffix, list);
            }
            this.maxLength = Math.max(this.maxLength, suffix.length());
            list.add(obj);
        }
    }

    @Override
    public void generate(Profiler prof) {
        BCLog.logger.info("[lib.search] Max suffix length is " + this.maxLength);
        for (String suffix : this.suffixArray.keySet()) {
            if (suffix.length() != this.maxLength) continue;
            BCLog.logger.info("[lib.search]   '" + suffix + "'");
        }
    }

    @Override
    public ISuffixArray.SearchResult<T> search(String substring, int maxResults) {
        int realResultCount;
        String[] array;
        ArrayList entries = new ArrayList();
        boolean first = true;
        for (String s : array = substring.split(" ")) {
            AbstractCollection real = first ? entries : new HashSet();
            for (List values : this.suffixArray.subMap((Object)s, (Object)(s + '\uffff')).values()) {
                real.addAll(values);
            }
            if (!first) {
                entries.retainAll(real);
            }
            first = false;
        }
        if (entries.size() > maxResults) {
            realResultCount = entries.size();
            entries.subList(maxResults, entries.size()).clear();
        } else {
            realResultCount = entries.size();
        }
        return new ISuffixArray.SearchResult(entries, realResultCount);
    }
}

