/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;

public class RotationUtil {
    public static AxisAlignedBB rotateAABB(AxisAlignedBB aabb, EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72337_e, aabb.field_72339_c, aabb.field_72336_d, aabb.field_72338_b, aabb.field_72334_f);
        }
        if (facing == EnumFacing.UP) {
            return new AxisAlignedBB(aabb.field_72340_a, 1.0 - aabb.field_72337_e, aabb.field_72339_c, aabb.field_72336_d, 1.0 - aabb.field_72338_b, aabb.field_72334_f);
        }
        if (facing == EnumFacing.NORTH) {
            return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72339_c, aabb.field_72338_b, aabb.field_72336_d, aabb.field_72334_f, aabb.field_72337_e);
        }
        if (facing == EnumFacing.SOUTH) {
            return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72339_c, 1.0 - aabb.field_72337_e, aabb.field_72336_d, aabb.field_72334_f, 1.0 - aabb.field_72338_b);
        }
        if (facing == EnumFacing.WEST) {
            return new AxisAlignedBB(aabb.field_72338_b, aabb.field_72339_c, aabb.field_72340_a, aabb.field_72337_e, aabb.field_72334_f, aabb.field_72336_d);
        }
        if (facing == EnumFacing.EAST) {
            return new AxisAlignedBB(1.0 - aabb.field_72337_e, aabb.field_72339_c, aabb.field_72340_a, 1.0 - aabb.field_72338_b, aabb.field_72334_f, aabb.field_72336_d);
        }
        return aabb;
    }

    public static Vec3d rotateVec3d(Vec3d vec, Rotation rotation) {
        switch (rotation) {
            default: {
                return vec;
            }
            case CLOCKWISE_90: {
                return new Vec3d(1.0 - vec.field_72449_c, vec.field_72448_b, vec.field_72450_a);
            }
            case CLOCKWISE_180: {
                return new Vec3d(1.0 - vec.field_72450_a, vec.field_72448_b, 1.0 - vec.field_72449_c);
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new Vec3d(vec.field_72449_c, vec.field_72448_b, 1.0 - vec.field_72450_a);
    }

    public static EnumFacing rotateAll(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return EnumFacing.EAST;
            }
            case EAST: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.UP;
            }
            case UP: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.NORTH;
            }
        }
        throw new IllegalArgumentException();
    }

    public static Rotation invert(Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return Rotation.NONE;
            }
            case CLOCKWISE_90: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case CLOCKWISE_180: {
                return Rotation.CLOCKWISE_180;
            }
            case COUNTERCLOCKWISE_90: {
                return Rotation.CLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException();
    }
}

