/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.enums.EnumPowerStage;
import buildcraft.energy.BCEnergyFluids;
import buildcraft.energy.tile.TileEngineIron_BC8;
import buildcraft.energy.tile.TileEngineStone_BC8;
import buildcraft.lib.client.model.ModelHolderVariable;
import buildcraft.lib.client.model.ModelItemSimple;
import buildcraft.lib.client.model.MutableQuad;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.expression.node.value.NodeVariableObject;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.misc.ExpressionCompat;
import buildcraft.lib.misc.data.ModelVariableData;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BCEnergyModels {
    private static final NodeVariableDouble ENGINE_PROGRESS;
    private static final NodeVariableObject<EnumPowerStage> ENGINE_STAGE;
    private static final NodeVariableObject<EnumFacing> ENGINE_FACING;
    private static final ModelHolderVariable ENGINE_STONE;
    private static final ModelHolderVariable ENGINE_IRON;

    public static void fmlPreInit() {
        MinecraftForge.EVENT_BUS.register(BCEnergyModels.class);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegistry(ModelRegistryEvent event) {
        for (BCFluid fluid : BCEnergyFluids.allFluids) {
            ModelLoader.setCustomStateMapper((Block)fluid.getBlock(), b -> Collections.emptyMap());
        }
    }

    @SubscribeEvent
    public static void onModelBake(ModelBakeEvent event) {
        BCEnergyModels.ENGINE_PROGRESS.value = 0.2;
        BCEnergyModels.ENGINE_STAGE.value = EnumPowerStage.BLUE;
        BCEnergyModels.ENGINE_FACING.value = EnumFacing.UP;
        ModelVariableData varData = new ModelVariableData();
        varData.setNodes(ENGINE_STONE.createTickableNodes());
        varData.tick();
        varData.refresh();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(EnumEngineType.STONE.getItemModelLocation(), "inventory"), (Object)new ModelItemSimple(Arrays.stream(ENGINE_STONE.getCutoutQuads()).map(MutableQuad::toBakedItem).collect(Collectors.toList()), ModelItemSimple.TRANSFORM_BLOCK, true));
        varData.setNodes(ENGINE_IRON.createTickableNodes());
        varData.tick();
        varData.refresh();
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation(EnumEngineType.IRON.getItemModelLocation(), "inventory"), (Object)new ModelItemSimple(Arrays.stream(ENGINE_IRON.getCutoutQuads()).map(MutableQuad::toBakedItem).collect(Collectors.toList()), ModelItemSimple.TRANSFORM_BLOCK, true));
        for (BCFluid fluid : BCEnergyFluids.allFluids) {
            ModelFluid modelFluid = new ModelFluid((Fluid)fluid);
            event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("buildcraftenergy:fluid_block_" + fluid.getBlockName()), (Object)modelFluid.bake(modelFluid.getDefaultState(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter()));
        }
    }

    private static MutableQuad[] getEngineQuads(ModelHolderVariable model, TileEngineBase_BC8 tile, float partialTicks) {
        BCEnergyModels.ENGINE_PROGRESS.value = tile.getProgressClient(partialTicks);
        BCEnergyModels.ENGINE_STAGE.value = tile.getPowerStage();
        BCEnergyModels.ENGINE_FACING.value = tile.getCurrentFacing();
        if (tile.clientModelData.hasNoNodes()) {
            tile.clientModelData.setNodes(model.createTickableNodes());
        }
        tile.clientModelData.refresh();
        return model.getCutoutQuads();
    }

    public static MutableQuad[] getStoneEngineQuads(TileEngineStone_BC8 tile, float partialTicks) {
        return BCEnergyModels.getEngineQuads(ENGINE_STONE, tile, partialTicks);
    }

    public static MutableQuad[] getIronEngineQuads(TileEngineIron_BC8 tile, float partialTicks) {
        return BCEnergyModels.getEngineQuads(ENGINE_IRON, tile, partialTicks);
    }

    static {
        FunctionContext fnCtx = new FunctionContext(ExpressionCompat.ENUM_POWER_STAGE, DefaultContexts.createWithAll());
        ENGINE_PROGRESS = fnCtx.putVariableDouble("progress");
        ENGINE_STAGE = fnCtx.putVariableObject("stage", EnumPowerStage.class);
        ENGINE_FACING = fnCtx.putVariableObject("direction", EnumFacing.class);
        ENGINE_STONE = new ModelHolderVariable("buildcraftenergy:models/block/engine_stone.json", fnCtx);
        ENGINE_IRON = new ModelHolderVariable("buildcraftenergy:models/block/engine_iron.json", fnCtx);
    }
}

