/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.launcher;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.launcher.Yggdrasil;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.FMLSecurityManager;
import org.apache.logging.log4j.LogManager;

public class FMLTweaker
implements ITweaker {
    private File gameDir;
    private Map<String, String> launchArgs;
    private List<String> standaloneArgs;
    private static URI jarLocation;

    public FMLTweaker() {
        if (System.getProperty("java.net.preferIPv4Stack") == null) {
            System.setProperty("java.net.preferIPv4Stack", "true");
        }
        try {
            System.setSecurityManager(new FMLSecurityManager());
        }
        catch (SecurityException se) {
            throw new RuntimeException("FML was unable to install the security manager. The game will not start", se);
        }
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        this.gameDir = gameDir == null ? new File(".") : gameDir;
        this.launchArgs = (Map)Launch.blackboard.get("launchArgs");
        this.standaloneArgs = Lists.newArrayList();
        if (this.launchArgs == null) {
            this.launchArgs = Maps.newHashMap();
            Launch.blackboard.put("launchArgs", this.launchArgs);
        }
        String classifier = null;
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (classifier != null) {
                    classifier = this.launchArgs.put(classifier, "");
                    continue;
                }
                if (arg.contains("=")) {
                    classifier = this.launchArgs.put(arg.substring(0, arg.indexOf(61)), arg.substring(arg.indexOf(61) + 1));
                    continue;
                }
                classifier = arg;
                continue;
            }
            if (classifier != null) {
                classifier = this.launchArgs.put(classifier, arg);
                continue;
            }
            this.standaloneArgs.add(arg);
        }
        if (!this.launchArgs.containsKey("--version")) {
            this.launchArgs.put("--version", profile != null ? profile : "UnknownFMLProfile");
        }
        if (!this.launchArgs.containsKey("--gameDir") && gameDir != null) {
            this.launchArgs.put("--gameDir", gameDir.getAbsolutePath());
        }
        if (!this.launchArgs.containsKey("--assetsDir") && assetsDir != null) {
            this.launchArgs.put("--assetsDir", assetsDir.getAbsolutePath());
        }
        Yggdrasil.login(this.launchArgs);
        Launch.blackboard.put("forgeLaunchArgs", Maps.newHashMap(this.launchArgs));
        try {
            jarLocation = this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            LogManager.getLogger((String)"FML.TWEAK").error("Missing URI information for FML tweak");
            throw new RuntimeException(e);
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        FMLLaunchHandler.configureForClientLaunch(classLoader, this);
        FMLLaunchHandler.appendCoreMods();
    }

    public String getLaunchTarget() {
        Map args = (Map)Launch.blackboard.get("launchArgs");
        args.remove("--modListFile");
        args.remove("--mods");
        return "net.minecraft.client.main.Main";
    }

    public String[] getLaunchArguments() {
        ArrayList args = Lists.newArrayList();
        args.addAll(this.standaloneArgs);
        for (Map.Entry<String, String> arg : this.launchArgs.entrySet()) {
            args.add(arg.getKey());
            args.add(arg.getValue());
        }
        this.launchArgs.clear();
        return args.toArray(new String[args.size()]);
    }

    public File getGameDir() {
        return this.gameDir;
    }

    public static URI getJarLocation() {
        return jarLocation;
    }

    public void injectCascadingTweak(String tweakClassName) {
        List tweakClasses = (List)Launch.blackboard.get("TweakClasses");
        tweakClasses.add(tweakClassName);
    }
}

