/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes;

import aroma1997.core.recipes.BasicAromicRecipe;
import aroma1997.core.recipes.IAromicRecipe;
import aroma1997.core.recipes.IRecipePart;
import aroma1997.core.recipes.RecipeUtil;
import java.util.HashMap;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class ShapedAromicRecipe
extends BasicAromicRecipe {
    static final int MAX_CRAFT_GRID_WIDTH = 3;
    static final int MAX_CRAFT_GRID_HEIGHT = 3;
    IRecipePart[] input = null;
    int width = 0;
    int height = 0;
    private boolean enableMirror = true;

    ShapedAromicRecipe() {
        super(ItemStack.field_190927_a);
    }

    public ShapedAromicRecipe(ItemStack result, Object ... recipe) {
        super(result);
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                this.width = s.length();
                shape = shape + (String)s;
            }
            this.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                this.width = s.length();
                ++this.height;
            }
        }
        if (this.width * this.height != shape.length()) {
            String ret = "Invalid shaped aromic recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.func_77571_b();
            throw new RuntimeException(ret);
        }
        HashMap<Character, IRecipePart> itemMap = new HashMap<Character, IRecipePart>();
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            itemMap.put(chr, RecipeUtil.getRecipePart(in));
            idx += 2;
        }
        this.input = new IRecipePart[this.width * this.height];
        int x = 0;
        for (char chr : shape.toCharArray()) {
            this.input[x++] = (IRecipePart)itemMap.get(Character.valueOf(chr));
        }
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.adjustOutput(this.func_77571_b(), var1);
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (!this.checkMatch(inv, x, y, false) && (!this.enableMirror || !this.checkMatch(inv, x, y, true))) continue;
                return true;
            }
        }
        return false;
    }

    boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        return this.getMatchingParts(inv, startX, startY, mirror) != null;
    }

    IRecipePart[] getMatchingParts(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        IRecipePart[] ret = new IRecipePart[inv.func_70302_i_()];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                IRecipePart target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target == null) {
                    if (slot.func_190926_b()) continue;
                    return null;
                }
                if (!target.doesItemMatch(slot) || target.getAmount(slot) > slot.func_190916_E() && this.checkStackSize()) {
                    return null;
                }
                ret[x + y * inv.func_174922_i()] = target;
            }
        }
        return ret;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        assert (this.func_77569_a(inv, null));
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        IRecipePart[] parts = null;
        block0: for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                parts = this.getMatchingParts(inv, x, y, false);
                if (parts == null && this.enableMirror) {
                    parts = this.getMatchingParts(inv, x, y, true);
                }
                if (parts != null) break block0;
            }
        }
        for (int i = 0; i < parts.length; ++i) {
            void part = parts[i];
            if (part == null) continue;
            list.set(i, (Object)part.getResult(inv.func_70301_a(i)));
        }
        return list;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= this.width && height >= this.height;
    }

    @Override
    public IRecipePart[] getInput() {
        return this.input;
    }

    public int getRecipeWidth() {
        return this.width;
    }

    public int getRecipeHeight() {
        return this.height;
    }

    @Override
    public boolean isMirrorOK() {
        return this.enableMirror;
    }

    @Override
    public IAromicRecipe setMirrorOK(boolean mirrorok) {
        this.enableMirror = mirrorok;
        return this;
    }
}

