/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.inventory.inventorypart;

import aroma1997.core.inventory.BasicInventory;
import aroma1997.core.inventory.IInventoryPartContainer;
import aroma1997.core.inventory.InvUtil;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class InventoryPartBase
extends BasicInventory
implements ISidedInventory,
Iterable<ItemStack> {
    protected final IInventoryPartContainer container;
    protected final boolean canAccept;
    protected final boolean canEmit;
    private final String name;

    public InventoryPartBase(IInventoryPartContainer container, String name, int size) {
        this(container, name, size, true, true);
    }

    public InventoryPartBase(IInventoryPartContainer container, String name, int size, boolean canAccept, boolean canEmit) {
        super(size);
        container.addInventoryPart(this);
        this.container = container;
        this.canAccept = canAccept;
        this.canEmit = canEmit;
        this.name = name;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] ret = new int[this.func_70302_i_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = i;
        }
        return ret;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack) && this.canAccept;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return this.canEmit;
    }

    public ItemStack addStack(ItemStack stack) {
        return InvUtil.putStackInInventoryInternal(stack, this, false);
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return Arrays.asList(this.inventory).stream().filter(stack -> stack != null && !stack.func_190926_b()).iterator();
    }

    public int getStartOffset() {
        int offset = 0;
        for (InventoryPartBase part : this.container.getParts()) {
            if (part == this) {
                return offset;
            }
            offset += part.func_70302_i_();
        }
        throw new IllegalStateException("Tried to get the offset of a InventoryPart, that is not in the inventory.");
    }

    public IInventoryPartContainer getContainer() {
        return this.container;
    }

    public void markDirtyInternal() {
    }

    @Override
    public final void func_70296_d() {
        super.func_70296_d();
        this.markDirtyInternal();
        this.container.markDirtyInternal();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        InvUtil.readFromNBT(this, nbt);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        return InvUtil.writeToNBT(this, nbt);
    }

    @Override
    public String func_70005_c_() {
        return this.name;
    }

    public ItemStack get() {
        return this.iterator().next();
    }
}

