/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.coremod.asm;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import org.objectweb.asm.ClassReader;

public class AsmUtils {
    private AsmUtils() {
    }

    public static int getReturnCodeForType(String str) {
        switch (str.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 172;
            }
            case 'J': {
                return 173;
            }
            case 'F': {
                return 174;
            }
            case 'D': {
                return 175;
            }
            case 'V': {
                return 177;
            }
            case 'L': {
                return 176;
            }
        }
        throw new IllegalArgumentException(str + " is not a valid type.");
    }

    public static int getLoadCodeForType(String str) {
        switch (str.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return 21;
            }
            case 'J': {
                return 22;
            }
            case 'F': {
                return 23;
            }
            case 'D': {
                return 24;
            }
            case 'L': {
                return 25;
            }
        }
        throw new IllegalArgumentException(str + " is not a valid type.");
    }

    public static String getDescriptorForClass(Class<?> c) {
        if (c.isPrimitive()) {
            if (c == Byte.TYPE) {
                return "B";
            }
            if (c == Character.TYPE) {
                return "C";
            }
            if (c == Double.TYPE) {
                return "D";
            }
            if (c == Float.TYPE) {
                return "F";
            }
            if (c == Integer.TYPE) {
                return "I";
            }
            if (c == Long.TYPE) {
                return "J";
            }
            if (c == Short.TYPE) {
                return "S";
            }
            if (c == Boolean.TYPE) {
                return "Z";
            }
            if (c == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized primitive " + c);
        }
        if (c.isArray()) {
            return c.getName().replace('.', '/');
        }
        return ('L' + c.getName() + ';').replace('.', '/');
    }

    public static String getMethodDescriptor(Method m) {
        String s = "(";
        for (Class<?> clazz : m.getParameterTypes()) {
            s = s + AsmUtils.getDescriptorForClass(clazz);
        }
        s = s + ')';
        return s + AsmUtils.getDescriptorForClass(m.getReturnType());
    }

    public static Iterator<String> splitParams(final String str) {
        return new Iterator<String>(){
            int currentPointer = 0;

            @Override
            public boolean hasNext() {
                return this.currentPointer < str.length();
            }

            @Override
            public String next() {
                String current = str.substring(this.currentPointer);
                int endIdx = current.charAt(0) == 'L' ? this.currentPointer + current.indexOf(59) + 1 : this.currentPointer + 1;
                String ret = str.substring(this.currentPointer, endIdx);
                this.currentPointer = endIdx;
                return ret;
            }
        };
    }

    public static String extractParameters(String descr) {
        int begin = descr.indexOf(40);
        int end = descr.indexOf(41);
        return descr.substring(begin + 1, end);
    }

    public static String extractReturnType(String descr) {
        int begin = descr.indexOf(41);
        return descr.substring(begin + 1);
    }

    public static ClassReader getClassReader(String name) throws IOException {
        return AsmUtils.getClassReader(AsmUtils.class.getClassLoader(), name);
    }

    public static ClassReader getClassReader(ClassLoader cl, String name) throws IOException {
        return new ClassReader(cl.getResourceAsStream(name.replace('.', '/') + ".class"));
    }
}

