/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core;

import aroma1997.core.CommonProxy;
import aroma1997.core.Reference;
import aroma1997.core.command.AromaCommand;
import aroma1997.core.command.SleepingCommand;
import aroma1997.core.config.Config;
import aroma1997.core.coremod.MCPNames;
import aroma1997.core.log.LogHelper;
import aroma1997.core.log.LogHelperPre;
import aroma1997.core.network.NetworkHelper;
import aroma1997.core.network.packets.CapePacket;
import aroma1997.core.network.packets.PacketContainerUpdate;
import aroma1997.core.network.packets.PacketTeUpdate;
import aroma1997.core.recipes.RecipeUtil;
import aroma1997.core.util.AromaRegistry;
import aroma1997.core.util.Util;
import aroma1997.core.util.registry.AromaAutoRegistry;
import aroma1997.core.util.registry.TickRegistry;
import java.io.File;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

@Mod(modid="aroma1997core", name="Aroma1997Core", certificateFingerprint="dfbfe4c473253d8c5652417689848f650b2cbe32", acceptedMinecraftVersions="[1.12]")
public class Aroma1997Core {
    @Mod.Instance
    public static Aroma1997Core instance;
    @SidedProxy(clientSide="aroma1997.core.client.ClientProxy", serverSide="aroma1997.core.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LogHelperPre.debugLog("Loading Aroma1997Core version " + Reference.VERSION + " for MC " + Reference.MCVERSION);
        Config.init();
        NetworkHelper.getCorePacketHandler();
        Util.forceLoadClass(AromaRegistry.class);
        proxy.registerRenderers();
        LogHelperPre.log(Level.INFO, "Finished Pre-initialization.");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        NetworkHelper.getCorePacketHandler().registerMessage(CapePacket.class, CapePacket.class, 0, Side.CLIENT);
        NetworkHelper.getCorePacketHandler().registerMessage(PacketTeUpdate.class, PacketTeUpdate.class, 1, null);
        NetworkHelper.getCorePacketHandler().registerMessage(PacketContainerUpdate.class, PacketContainerUpdate.class, 2, null);
        RecipeUtil.registerRecipeFactories();
        AromaAutoRegistry.INSTANCE.init();
        LogHelperPre.log(Level.INFO, "Finished Initialization.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Util.forceLoadClass(MCPNames.class);
        Util.forceLoadClass(TickRegistry.class);
    }

    @Mod.EventHandler
    public void serverStartup(FMLServerStartingEvent event) {
        File file = new File(Util.getWorldFolder(), "aroma1997");
        if (!file.exists()) {
            file.mkdir();
        }
        event.registerServerCommand((ICommand)new SleepingCommand(event.getServer()));
        event.registerServerCommand((ICommand)new AromaCommand());
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
        LogHelper.log(Level.WARN, "Invalid fingerprint detected! The version of the mod is most likely modified and an inofficial release.");
        LogHelper.log(Level.WARN, "Use with caution.");
    }

    @NetworkCheckHandler
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return true;
    }
}

