/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.network.messages;

import io.netty.buffer.ByteBuf;
import k4unl.minecraft.k4lib.network.messages.AbstractPacket;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class LocationIntPacket<REQ extends IMessage>
extends AbstractPacket<REQ> {
    protected int x;
    protected int y;
    protected int z;
    protected BlockPos pos;

    public LocationIntPacket() {
    }

    public LocationIntPacket(BlockPos pos) {
        this.x = pos.func_177958_n();
        this.y = pos.func_177956_o();
        this.z = pos.func_177952_p();
        this.pos = pos;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.pos = new BlockPos(this.x, this.y, this.z);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world) {
        return this.getTargetPoint(world, 64.0);
    }

    public NetworkRegistry.TargetPoint getTargetPoint(World world, double updateDistance) {
        return new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)this.x, (double)this.y, (double)this.z, updateDistance);
    }

    protected Block getBlock(World world) {
        return world.func_180495_p(this.pos).func_177230_c();
    }
}

