/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import k4unl.minecraft.k4lib.network.EnumSIPValues;

public class SipEndPoint {
    private InetSocketAddress address;
    private Map<String, String> values;
    private String[] onlineUsernames;
    private Map<String, Object> extendedValues;

    public SipEndPoint(String host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public SipEndPoint(InetSocketAddress address) {
        this.address = address;
    }

    public Map<String, String> getValues() {
        if (this.values == null) {
            throw new IllegalStateException("Query has not been sent yet!");
        }
        return this.values;
    }

    public String[] getOnlineUsernames() {
        if (this.onlineUsernames == null) {
            throw new IllegalStateException("Query has not been sent yet!");
        }
        return this.onlineUsernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestExtendedInfo(EnumSIPValues ... values) throws IOException {
        try (Socket socket = new Socket(this.address.getAddress(), this.address.getPort());){
            String line;
            socket.setSoTimeout(5000);
            ArrayList<String> toRequest = new ArrayList<String>();
            for (EnumSIPValues value : values) {
                toRequest.add(value.toString());
            }
            GsonBuilder builder = new GsonBuilder();
            Gson gson = builder.create();
            String endString = gson.toJson(toRequest);
            PrintWriter os = new PrintWriter(socket.getOutputStream());
            os.write(endString + "\n");
            os.flush();
            BufferedReader is = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            String json = "";
            while ((line = is.readLine()) != null) {
                json = json + line;
            }
            this.extendedValues = (Map)gson.fromJson(json, HashMap.class);
        }
    }

    public Object getExtendedObject(EnumSIPValues key) {
        if (this.extendedValues.containsKey(key.toString())) {
            return this.extendedValues.get(key.toString());
        }
        return null;
    }
}

