/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.network;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import k4unl.minecraft.k4lib.lib.Log;
import k4unl.minecraft.k4lib.network.EnumSIPValues;

public class Query {
    private InetSocketAddress address;
    private Map<String, String> values;
    private String[] onlineUsernames;
    private Map<String, Object> extendedValues;
    private int tcpPort = 0;

    public Query(String host, int port) {
        this(new InetSocketAddress(host, port));
    }

    public Query(InetSocketAddress address) {
        this.address = address;
    }

    public void sendQuery() throws IOException {
        this.sendQueryRequest();
    }

    public boolean pingServer() {
        try {
            Socket socket = new Socket();
            socket.connect(this.address, 1500);
            socket.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public Map<String, String> getValues() {
        if (this.values == null) {
            throw new IllegalStateException("Query has not been sent yet!");
        }
        return this.values;
    }

    public String[] getOnlineUsernames() {
        if (this.onlineUsernames == null) {
            throw new IllegalStateException("Query has not been sent yet!");
        }
        return this.onlineUsernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueryRequest() throws IOException {
        try (DatagramSocket socket = new DatagramSocket();){
            String s;
            byte[] receiveData = new byte[10240];
            socket.setSoTimeout(2000);
            Query.sendPacket(socket, this.address, 254, 253, 9, 1, 1, 1, 1);
            Query.receivePacket(socket, receiveData);
            int byte1 = -1;
            int i = 0;
            byte[] buffer = new byte[8];
            int count = 5;
            while ((byte1 = receiveData[count++]) != 0) {
                buffer[i++] = byte1;
            }
            int challengeInteger = Integer.parseInt(new String(buffer).trim());
            Query.sendPacket(socket, this.address, 254, 253, 0, 1, 1, 1, 1, challengeInteger >> 24, challengeInteger >> 16, challengeInteger >> 8, challengeInteger, 0, 0, 0, 0);
            int length = Query.receivePacket(socket, receiveData).getLength();
            this.values = new HashMap<String, String>();
            AtomicInteger cursor = new AtomicInteger(5);
            while (cursor.get() < length && (s = Query.readString(receiveData, cursor)).length() != 0) {
                String v = Query.readString(receiveData, cursor);
                this.values.put(s, v);
            }
            Query.readString(receiveData, cursor);
            HashSet<String> players = new HashSet<String>();
            while (cursor.get() < length) {
                String name = Query.readString(receiveData, cursor);
                if (name.length() <= 0) continue;
                players.add(name);
            }
            this.onlineUsernames = players.toArray(new String[players.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivePort() throws IOException {
        DatagramSocket socket = new DatagramSocket();
        try {
            Log.debug("Requesting extended info", new Object[0]);
            byte[] receiveData = new byte[socket.getReceiveBufferSize()];
            socket.setSoTimeout(800);
            Query.sendPacket(socket, this.address, 254, 253, 9, 1, 1, 1, 1);
            Query.receivePacket(socket, receiveData);
            int byte1 = -1;
            int i = 0;
            byte[] buffer = new byte[8];
            int count = 5;
            while ((byte1 = receiveData[count++]) != 0) {
                buffer[i++] = byte1;
            }
            int challengeInteger = Integer.parseInt(new String(buffer).trim());
            Query.sendPacket(socket, this.address, 254, 253, 8, 1, 1, 1, 1, challengeInteger >> 24, challengeInteger >> 16, challengeInteger >> 8, challengeInteger);
            int length = Query.receivePacket(socket, receiveData).getLength();
            this.handleExtendedPacket(receiveData, length);
        }
        finally {
            Log.debug("Closing socket", new Object[0]);
            socket.close();
        }
    }

    private void handleExtendedPacket(byte[] receiveData, int length) {
        int i = 5;
        String json = "";
        for (i = 5; i < length - 1; ++i) {
            byte b = receiveData[i];
            json = json + (char)b;
        }
        this.tcpPort = Integer.parseInt(json);
    }

    private static final void sendPacket(DatagramSocket socket, InetSocketAddress targetAddress, byte ... data) throws IOException {
        DatagramPacket sendPacket = new DatagramPacket(data, data.length, targetAddress.getAddress(), targetAddress.getPort());
        socket.send(sendPacket);
    }

    private static final void sendPacket(DatagramSocket socket, InetSocketAddress targetAddress, Object ... data) throws IOException {
        ArrayList<Byte> list = new ArrayList<Byte>();
        int i = 0;
        for (Object j : data) {
            if (j instanceof Integer) {
                list.add((byte)((Integer)j & 0xFF));
                continue;
            }
            if (!(j instanceof String)) continue;
            for (char c : ((String)j).toCharArray()) {
                list.add((byte)c);
            }
        }
        byte[] d = new byte[list.size()];
        for (Byte b : list) {
            d[i++] = b;
        }
        Query.sendPacket(socket, targetAddress, d);
    }

    private static final DatagramPacket receivePacket(DatagramSocket socket, byte[] buffer) throws IOException {
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        try {
            socket.receive(dp);
        }
        catch (SocketTimeoutException ex) {
            socket.disconnect();
            socket.close();
        }
        return dp;
    }

    private static final String readString(byte[] array, AtomicInteger cursor) {
        int startPosition = cursor.incrementAndGet();
        while (cursor.get() < array.length && array[cursor.get()] != 0) {
            cursor.incrementAndGet();
        }
        return new String(Arrays.copyOfRange(array, startPosition, cursor.get()));
    }

    public Object getExtendedObject(EnumSIPValues key) {
        if (this.extendedValues.containsKey(key.toString())) {
            return this.extendedValues.get(key.toString());
        }
        return null;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }
}

