/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.network;

import k4unl.minecraft.k4lib.network.messages.LocationDoublePacket;
import k4unl.minecraft.k4lib.network.messages.LocationIntPacket;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public abstract class NetworkHandler {
    public final NetworkHandler INSTANCE;
    protected int discriminant;
    private SimpleNetworkWrapper channel = NetworkRegistry.INSTANCE.newSimpleChannel(this.getModId());

    public NetworkHandler() {
        this.INSTANCE = this;
    }

    public abstract String getModId();

    public abstract void init();

    public SimpleNetworkWrapper getChannel() {
        return this.channel;
    }

    public void sendToAll(IMessage message) {
        this.channel.sendToAll(message);
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        this.channel.sendTo(message, player);
    }

    public void sendToAllAround(LocationIntPacket message, World world, double distance) {
        this.sendToAllAround((IMessage)message, message.getTargetPoint(world, distance));
    }

    public void sendToAllAround(LocationIntPacket message, World world) {
        this.sendToAllAround((IMessage)message, message.getTargetPoint(world));
    }

    public void sendToAllAround(LocationDoublePacket message, World world) {
        this.sendToAllAround((IMessage)message, message.getTargetPoint(world));
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.channel.sendToAllAround(message, point);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        this.channel.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.channel.sendToServer(message);
    }
}

