/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.lib.config;

import net.minecraftforge.common.config.Configuration;

public class ConfigOption {
    private Configuration config;
    private String key;
    private boolean isBool = false;
    private boolean isInt = false;
    private boolean isString = false;
    private boolean isChar = false;
    private boolean isDouble = false;
    private boolean val;
    private boolean def;
    private int valInt;
    private int defInt;
    private String valString;
    private String defString;
    private char valChar;
    private char defChar;
    private double valDouble;
    private double defDouble;
    private String category = "general";
    private String comment = "";

    public ConfigOption(String _key, boolean _def) {
        this.key = _key;
        this.val = _def;
        this.def = _def;
        this.isBool = true;
        this.updateComment();
    }

    public ConfigOption(String _key, int _def) {
        this.key = _key;
        this.valInt = _def;
        this.defInt = _def;
        this.isInt = true;
        this.updateComment();
    }

    public ConfigOption(String _key, String _def) {
        this.key = _key;
        this.valString = _def;
        this.defString = _def;
        this.isString = true;
        this.updateComment();
    }

    public ConfigOption(String _key, char _def) {
        this.key = _key;
        this.valChar = _def;
        this.defChar = _def;
        this.isChar = true;
        this.updateComment();
    }

    public ConfigOption(String _key, double _def) {
        this.key = _key;
        this.valDouble = _def;
        this.defDouble = _def;
        this.isDouble = true;
        this.updateComment();
    }

    private void updateComment() {
        if (this.isDouble) {
            this.comment = this.comment + " [Default: " + this.defDouble + "]";
        } else if (this.isBool) {
            this.comment = this.comment + " [Default: " + this.def + "]";
        } else if (this.isChar) {
            this.comment = this.comment + " [Default: " + this.defChar + "]";
        } else if (this.isInt) {
            this.comment = this.comment + " [Default: " + this.defInt + "]";
        } else if (this.isString) {
            this.comment = this.comment + " [Default: " + this.defString + "]";
        }
    }

    public String getComment() {
        return this.comment;
    }

    public ConfigOption setComment(String newComment) {
        this.comment = newComment;
        this.updateComment();
        return this;
    }

    public String getCategory() {
        return this.category;
    }

    public ConfigOption setCategory(String newCat) {
        this.category = newCat;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public boolean getBool() {
        return this.val;
    }

    public void setBool(boolean newValue) {
        this.val = newValue;
    }

    public int getInt() {
        return this.valInt;
    }

    public void setInt(int newValue) {
        this.valInt = newValue;
    }

    public String getString() {
        return this.valString;
    }

    public void setString(String newVal) {
        this.valString = newVal;
    }

    public char getChar() {
        return this.valChar;
    }

    public void setChar(char newValue) {
        this.valChar = newValue;
    }

    public double getDouble() {
        return this.valDouble;
    }

    public void setDouble(double newValue) {
        this.valDouble = newValue;
    }

    public void saveConfig() {
        if (this.isBool) {
            this.config.get(this.category, this.key, this.def).set(this.val);
            if (!this.comment.equals("")) {
                this.config.get(this.category, this.key, this.def).setComment(this.comment);
            }
        } else if (this.isInt) {
            this.config.get(this.category, this.key, this.defInt).set(this.valInt);
            if (!this.comment.equals("")) {
                this.config.get(this.category, this.key, this.defInt).setComment(this.comment);
            }
        } else if (this.isString) {
            this.config.get(this.category, this.key, this.defString).set(this.valString);
            if (!this.comment.equals("")) {
                this.config.get(this.category, this.key, this.defString).setComment(this.comment);
            }
        } else if (this.isChar) {
            this.config.get(this.category, this.key, this.defChar + "").set(this.valChar + "");
            if (!this.comment.equals("")) {
                this.config.get(this.category, this.key, this.defChar + "").setComment(this.comment);
            }
        } else if (this.isDouble) {
            this.config.get(this.category, this.key, this.defDouble).set(this.valDouble);
            if (!this.comment.equals("")) {
                this.config.get(this.category, this.key, this.defDouble).setComment(this.comment);
            }
        }
        this.config.save();
    }

    public void loadFromConfig(Configuration config) {
        this.config = config;
        if (this.isBool) {
            this.val = config.get(this.category, this.key, this.def).getBoolean(this.def);
            if (!this.comment.equals("")) {
                config.get(this.category, this.key, this.def).setComment(this.comment);
            }
        } else if (this.isInt) {
            this.valInt = config.get(this.category, this.key, this.defInt).getInt(this.defInt);
            if (!this.comment.equals("")) {
                config.get(this.category, this.key, this.defInt).setComment(this.comment);
            }
        } else if (this.isString) {
            this.valString = config.get(this.category, this.key, this.defString).getString();
            if (!this.comment.equals("")) {
                config.get(this.category, this.key, this.defString).setComment(this.comment);
            }
        } else if (this.isChar) {
            String t = config.get(this.category, this.key, this.defChar + "").getString();
            if (!this.comment.equals("")) {
                config.get(this.category, this.key, this.defChar + "").setComment(this.comment);
            }
            if (t.length() > 0) {
                this.valChar = t.charAt(0);
            }
        } else if (this.isDouble) {
            this.valDouble = config.get(this.category, this.key, this.defDouble).getDouble();
            if (!this.comment.equals("")) {
                config.get(this.category, this.key, this.defDouble).setComment(this.comment);
            }
        }
    }
}

