/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.lib;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;

public class SimpleInventory
implements IInventory {
    protected final ItemStack[] inventory;
    protected final String inventoryName;
    protected final int inventoryLimit;
    protected Container owner;

    public SimpleInventory(int slots, String inventoryName, int inventoryLimit, Container container) {
        this.inventoryName = inventoryName;
        this.inventoryLimit = inventoryLimit;
        this.inventory = new ItemStack[slots];
        this.owner = container;
    }

    public SimpleInventory(int slots, String inventoryName, int inventoryLimit) {
        this.inventoryName = inventoryName;
        this.inventoryLimit = inventoryLimit;
        this.inventory = new ItemStack[slots];
    }

    public SimpleInventory(int slots) {
        this.inventoryName = "";
        this.inventoryLimit = 64;
        this.inventory = new ItemStack[slots];
    }

    public Container getContainer() {
        return this.owner;
    }

    public void setContainer(Container container) {
        this.owner = container;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean func_191420_l() {
        return false;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = null;
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].func_190916_E() <= amount) {
                stack = this.inventory[slot];
                this.inventory[slot] = null;
            } else {
                stack = this.inventory[slot].func_77979_a(amount);
                if (this.inventory[slot].func_190916_E() == 0) {
                    this.inventory[slot] = null;
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70298_a(index, this.func_70301_a(index).func_190916_E());
    }

    public void func_70299_a(int slot, ItemStack item) {
        this.inventory[slot] = item;
    }

    public int func_70297_j_() {
        return this.inventoryLimit;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer playerIn) {
    }

    public void func_174886_c(EntityPlayer playerIn) {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public void load(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("Inventory", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = tag.func_74767_n("Empty") ? null : new ItemStack(tag);
        }
    }

    public void save(NBTTagCompound nbt) {
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            NBTTagCompound tag;
            ItemStack stack = this.inventory[i];
            if (stack != null) {
                tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
                continue;
            }
            tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            tag.func_74757_a("Empty", true);
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Inventory", (NBTBase)itemList);
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

