/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.lib;

import k4unl.minecraft.k4lib.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictionaryHelper {
    private static boolean doesOreNameExist(String name) {
        NonNullList stacks = OreDictionary.getOres((String)name);
        if (stacks.size() == 0) {
            return false;
        }
        boolean foundValid = false;
        for (ItemStack stack : stacks) {
            if (stack == null || stack.func_77973_b() == null) {
                Log.error("Some mod has registered a null itemstack or an itemstack with a null item\ninto oredictionary for " + name + ".\nThis is NOT a K4Lib/.. issue! Do NOT report it to us! We have no way of knowing the owner!", new Object[0]);
                continue;
            }
            foundValid = true;
        }
        return foundValid;
    }

    public static Item findValidItem(String name) {
        NonNullList stacks = OreDictionary.getOres((String)name);
        for (ItemStack stack : stacks) {
            if (stack == null || stack.func_77973_b() == null) continue;
            return stack.func_77973_b();
        }
        Log.error("For some reason I have not found any valid itemstack. This is going to crash eventually...", new Object[0]);
        return null;
    }

    public static Block findValidBlock(String name) {
        return Block.func_149634_a((Item)OreDictionaryHelper.findValidItem(name));
    }
}

