/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.lib;

import com.mojang.authlib.GameProfile;
import java.util.List;
import k4unl.minecraft.k4lib.lib.Location;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketTitle;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Functions {
    public static List mergeList(List l1, List l2) {
        for (Object object : l1) {
            if (l2.contains(object)) continue;
            l2.add(object);
        }
        return l2;
    }

    public static boolean isInString(String oreName, String[] list) {
        boolean ret = false;
        for (int i = 0; i < list.length; ++i) {
            ret = ret || oreName.substring(0, list[i].length()).equals(list[i]);
        }
        return ret;
    }

    public static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static boolean isPlayerOpped(GameProfile player) {
        if (Functions.getServer().func_184103_al().func_152606_n().length > 0) {
            for (String name : Functions.getServer().func_184103_al().func_152606_n()) {
                if (!name.toLowerCase().equals(player.getName().toLowerCase())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void sendChatMessageServerWide(TextComponentString message) {
        for (EntityPlayer player : Functions.getServer().func_184103_al().func_181057_v()) {
            player.func_145747_a((ITextComponent)message);
        }
    }

    public static RayTraceResult getEntityLookedObject(EntityLivingBase entity, float maxDistance) {
        Vec3d entityVec = new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e() - entity.func_70033_W() - (entity.func_70093_af() ? 0.08 : 0.0), entity.field_70161_v);
        Vec3d entityLookVec = entity.func_70676_i(1.0f);
        Vec3d maxDistVec = entityVec.func_72441_c(entityLookVec.field_72450_a * (double)maxDistance, entityLookVec.field_72448_b * (double)maxDistance, entityLookVec.field_72449_c * (double)maxDistance);
        return entity.func_130014_f_().func_72933_a(entityVec, maxDistVec);
    }

    public static Location getEntityLookedBlock(EntityLivingBase entity, float maxDistance) {
        RayTraceResult hit = Functions.getEntityLookedObject(entity, maxDistance);
        if (hit == null || hit.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return new Location(hit.func_178782_a().func_177958_n(), hit.func_178782_a().func_177956_o(), hit.func_178782_a().func_177952_p());
    }

    public static boolean isInDev() {
        return Boolean.parseBoolean(System.getProperty("k4lib.dev", "false"));
    }

    public static int getPlayerXP(EntityPlayer player) {
        return (int)((float)Functions.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static void addPlayerXP(EntityPlayer player, int amount) {
        int experience;
        player.field_71067_cb = experience = Functions.getPlayerXP(player) + amount;
        player.field_71068_ca = Functions.getLevelForExperience(experience);
        int expForLevel = Functions.getExperienceForLevel(player.field_71068_ca);
        player.field_71106_cc = (float)(experience - expForLevel) / (float)player.func_71050_bK();
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static int getXpToNextLevel(int level) {
        int levelXP = Functions.getLevelForExperience(level);
        int nextXP = Functions.getExperienceForLevel(level + 1);
        return nextXP - levelXP;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        while (Functions.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static TextureAtlasSprite getFluidIcon(Fluid fluid) {
        return Minecraft.func_71410_x().func_147117_R().getTextureExtry(fluid.getFlowing().toString());
    }

    public static void displayTitleMessage(SPacketTitle.Type titleType, EntityPlayerMP entityPlayerMP, ITextComponent toShow) {
        SPacketTitle spackettitle = new SPacketTitle(titleType, toShow);
        entityPlayerMP.field_71135_a.func_147359_a((Packet)spackettitle);
    }

    public static WorldServer getWorldServerForDimensionId(int dimensionId) {
        for (WorldServer server : Functions.getServer().field_71305_c) {
            if (server.field_73011_w.getDimension() != dimensionId) continue;
            return server;
        }
        return null;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack in) {
        Block block = Block.func_149634_a((Item)in.func_77973_b());
        return block.func_176203_a(in.func_77952_i());
    }
}

