/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import k4unl.minecraft.k4lib.client.gui.elements.GuiButton;
import k4unl.minecraft.k4lib.client.gui.elements.GuiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class GuiWithWidgets
extends GuiScreen {
    protected int xSize = 176;
    protected int ySize = 224;
    protected int guiLeft;
    protected int guiTop;
    private List<GuiWidget> widgetList = new ArrayList<GuiWidget>();
    protected List<GuiButton> field_146292_n = Lists.newArrayList();

    protected abstract void drawBackground();

    protected abstract void renderForeground(int var1, int var2);

    public void func_73866_w_() {
        this.widgetList.clear();
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        mouseX -= this.guiLeft;
        mouseY -= this.guiTop;
        if (mouseButton == 0) {
            for (GuiWidget widget : this.widgetList) {
                if (mouseX < widget.getX() || mouseX > widget.getX() + widget.getWidth() || mouseY < widget.getY() || mouseY > widget.getY() + widget.getHeight()) continue;
                widget.onMouseClick(mouseX, mouseY);
            }
            for (GuiButton button : this.field_146292_n) {
                if (!button.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY)) continue;
                button.func_146113_a(this.field_146297_k.func_147118_V());
                button.getCallback().accept(button);
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c - this.guiLeft;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1 - this.guiTop;
        for (GuiWidget widget : this.widgetList) {
            if (mouseX >= widget.getX() && mouseX <= widget.getX() + widget.getWidth() && mouseY >= widget.getY() && mouseY <= widget.getY() + widget.getHeight()) {
                widget.onHouseHover(Mouse.getEventX() - widget.getX(), Mouse.getEventY() - widget.getY());
                widget.setHover(true);
                continue;
            }
            if (!widget.isHover()) continue;
            widget.setHover(false);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        mouseX -= this.guiLeft;
        mouseY -= this.guiTop;
        this.func_146276_q_();
        this.drawBackground();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        this.renderForeground(mouseX, mouseY);
        for (GuiWidget guiWidget : this.widgetList) {
            guiWidget.doRender();
        }
        for (net.minecraft.client.gui.GuiButton guiButton : this.field_146292_n) {
            guiButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
        for (GuiLabel guiLabel : this.field_146293_o) {
            guiLabel.func_146159_a(this.field_146297_k, mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    protected void addWidget(GuiWidget widget) {
        if (!this.widgetList.contains(widget)) {
            this.widgetList.add(widget);
        }
    }

    public boolean func_73868_f() {
        return true;
    }
}

