/*
 * Decompiled with CFR 0.152.
 */
package k4unl.minecraft.k4lib.client;

import k4unl.minecraft.k4lib.lib.Vector3fMax;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderHelper {
    static float lightBottom = 0.5f;
    static float lightTop = 1.0f;
    static float lightEastWest = 0.8f;
    static float lightNorthSouth = 0.6f;
    private static Tessellator tess = Tessellator.func_178181_a();
    private static BufferBuilder worldRenderer = tess.func_178180_c();
    public static float pixel = 0.0625f;
    public static float renderPixel = 0.03125f;
    public static float bigRenderPixel = 0.015625f;

    public static void vertexWithTexture(float x, float y, float z, float tL, float tT) {
        GL11.glTexCoord2f((float)tL, (float)tT);
        GL11.glVertex3f((float)x, (float)y, (float)z);
    }

    public static void tesselatedTexture(float x, float y, float z, float tL, float tT) {
        worldRenderer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)tL, (double)tT).func_181675_d();
    }

    public static void tesselatedTexture(float x, float y, float z, float tL, float tT, int brightness) {
        int j = brightness >> 16 & 0xFFFF;
        int k = brightness & 0xFFFF;
        worldRenderer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)tL, (double)tT).func_187314_a(j, k).func_181675_d();
    }

    public static void startDrawingQuads() {
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
    }

    public static void tesselatorDraw() {
        tess.func_78381_a();
    }

    public static void drawCube(Vector3fMax vector) {
        RenderHelper.drawTexturedCube(vector);
    }

    public static void drawCube(Vector3fMax vector, boolean doColors) {
        if (doColors) {
            RenderHelper.drawColoredCube(vector);
        } else {
            RenderHelper.drawCube(vector);
        }
    }

    public static void setBrightness(int brightness) {
        int j = brightness >> 16 & 0xFFFF;
        int k = brightness & 0xFFFF;
        worldRenderer.func_187314_a(j, k);
    }

    public static void drawColoredCube(Vector3fMax vector) {
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
    }

    public static void setARGBFromHex(int hexColor) {
        float a = (float)(hexColor >> 24 & 0xFF) / 255.0f;
        float r = (float)(hexColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(hexColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(hexColor & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void setRGBFromHex(int hexColor) {
        float r = (float)(hexColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(hexColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(hexColor & 0xFF) / 255.0f;
        GL11.glColor3f((float)r, (float)g, (float)b);
    }

    public static void drawCubeWithoutColor(Vector3fMax vector) {
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
    }

    public static void drawTesselatedCube(Vector3fMax vector) {
        boolean wasTesselating = false;
        try {
            RenderHelper.startDrawingQuads();
        }
        catch (IllegalStateException e) {
            wasTesselating = true;
        }
        worldRenderer.func_181666_a(1.0f, 0.0f, 0.0f, 0.7f);
        worldRenderer.func_181663_c(0.0f, 1.0f, 0.0f);
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMax(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMax(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMax(), (double)vector.getZMin());
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMax(), (double)vector.getZMin());
        worldRenderer.func_181663_c(0.0f, -1.0f, 0.0f);
        worldRenderer.func_181666_a(1.0f, 1.0f, 0.0f, 0.7f);
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMin(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMin(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMin(), (double)vector.getZMin());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMin(), (double)vector.getZMin());
        worldRenderer.func_181663_c(-1.0f, 0.0f, 0.0f);
        worldRenderer.func_181666_a(0.0f, 1.0f, 0.0f, 0.7f);
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMin(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMax(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMax(), (double)vector.getZMin());
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMin(), (double)vector.getZMin());
        worldRenderer.func_181663_c(1.0f, 0.0f, 0.0f);
        worldRenderer.func_181666_a(0.0f, 1.0f, 1.0f, 0.7f);
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMin(), (double)vector.getZMin());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMax(), (double)vector.getZMin());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMax(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMin(), (double)vector.getZMax());
        worldRenderer.func_181663_c(0.0f, 0.0f, -1.0f);
        worldRenderer.func_181666_a(0.0f, 0.0f, 1.0f, 0.7f);
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMin(), (double)vector.getZMin());
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMax(), (double)vector.getZMin());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMax(), (double)vector.getZMin());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMin(), (double)vector.getZMin());
        worldRenderer.func_181663_c(0.0f, 0.0f, 1.0f);
        worldRenderer.func_181666_a(0.0f, 0.0f, 0.0f, 0.7f);
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMin(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMin(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMax(), (double)vector.getYMax(), (double)vector.getZMax());
        worldRenderer.func_181662_b((double)vector.getXMin(), (double)vector.getYMax(), (double)vector.getZMax());
        if (!wasTesselating) {
            tess.func_78381_a();
        }
    }

    public static boolean beginTesselatingWithTexture() {
        boolean wasTessellating = false;
        try {
            RenderHelper.startDrawingQuads();
        }
        catch (IllegalStateException e) {
            wasTessellating = true;
        }
        FMLClientHandler.instance().getClient().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        return wasTessellating;
    }

    public static void drawTesselatedSideTopWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        worldRenderer.func_181663_c(0.0f, 1.0f, 0.0f);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g());
    }

    public static void drawTesselatedSideTopWithTexture(Vector3fMax vector, TextureAtlasSprite icon, int brightness) {
        worldRenderer.func_181663_c(0.0f, 1.0f, 0.0f);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g(), brightness);
    }

    public static void drawTesselatedSideBottomWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        worldRenderer.func_181663_c(0.0f, -1.0f, 0.0f);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g());
    }

    public static void drawTesselatedSideBottomWithTexture(Vector3fMax vector, TextureAtlasSprite icon, int brightness) {
        worldRenderer.func_181663_c(0.0f, -1.0f, 0.0f);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g(), brightness);
    }

    public static void drawTesselatedSideWestWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        worldRenderer.func_181663_c(-1.0f, 0.0f, 0.0f);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g());
    }

    public static void drawTesselatedSideWestWithTexture(Vector3fMax vector, TextureAtlasSprite icon, int brightness) {
        worldRenderer.func_181663_c(-1.0f, 0.0f, 0.0f);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94206_g(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g(), brightness);
    }

    public static void drawTesselatedSideEastWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        worldRenderer.func_181663_c(1.0f, 0.0f, 0.0f);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h());
    }

    public static void drawTesselatedSideEastWithTexture(Vector3fMax vector, TextureAtlasSprite icon, int brightness) {
        worldRenderer.func_181663_c(1.0f, 0.0f, 0.0f);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94206_g(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h(), brightness);
    }

    public static void drawTesselatedSideNorthWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        worldRenderer.func_181663_c(0.0f, 0.0f, -1.0f);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g());
    }

    public static void drawTesselatedSideNorthWithTexture(Vector3fMax vector, TextureAtlasSprite icon, int brightness) {
        worldRenderer.func_181663_c(0.0f, 0.0f, -1.0f);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g(), brightness);
    }

    public static void drawTesselatedSideSouthWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        worldRenderer.func_181663_c(0.0f, 0.0f, 1.0f);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h());
    }

    public static void drawTesselatedSideSouthWithTexture(Vector3fMax vector, TextureAtlasSprite icon, int brightness) {
        worldRenderer.func_181663_c(0.0f, 0.0f, 1.0f);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94206_g(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94206_g(), brightness);
        RenderHelper.tesselatedTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h(), brightness);
    }

    public static void stopTesselating(boolean wasTessellating) {
        if (!wasTessellating) {
            tess.func_78381_a();
        }
    }

    public static void drawTesselatedCubeWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        boolean wasTessellating = RenderHelper.beginTesselatingWithTexture();
        RenderHelper.drawTesselatedSideTopWithTexture(vector, icon);
        RenderHelper.drawTesselatedSideBottomWithTexture(vector, icon);
        RenderHelper.drawTesselatedSideWestWithTexture(vector, icon);
        RenderHelper.drawTesselatedSideEastWithTexture(vector, icon);
        RenderHelper.drawTesselatedSideNorthWithTexture(vector, icon);
        RenderHelper.drawTesselatedSideSouthWithTexture(vector, icon);
        RenderHelper.stopTesselating(wasTessellating);
    }

    public static void drawTesselatedCubeWithTexture(Vector3fMax vector, TextureAtlasSprite icon, int brightness) {
        boolean wasTessellating = RenderHelper.beginTesselatingWithTexture();
        RenderHelper.drawTesselatedSideTopWithTexture(vector, icon, brightness);
        RenderHelper.drawTesselatedSideBottomWithTexture(vector, icon, brightness);
        RenderHelper.drawTesselatedSideWestWithTexture(vector, icon, brightness);
        RenderHelper.drawTesselatedSideEastWithTexture(vector, icon, brightness);
        RenderHelper.drawTesselatedSideNorthWithTexture(vector, icon, brightness);
        RenderHelper.drawTesselatedSideSouthWithTexture(vector, icon, brightness);
        RenderHelper.stopTesselating(wasTessellating);
    }

    public static void drawTexturedCube(Vector3fMax vector) {
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), 0.0f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), 0.5f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), 0.5f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), 0.0f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), 0.0f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), 0.5f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), 0.5f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), 0.0f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), 0.5f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), 0.5f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), 0.0f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), 0.0f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), 0.5f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), 0.5f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), 0.0f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), 0.0f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), 0.5f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), 0.5f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), 0.0f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), 0.0f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), 0.0f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), 0.5f, 0.0f);
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), 0.5f, 0.5f);
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), 0.0f, 0.5f);
    }

    public static void drawTexturedCubeWithLight(Vector3fMax vector, TileEntity t) {
        RenderHelper.drawTexturedCube(vector);
    }

    public static void draw2DCircle(float xCenter, float yCenter, float r) {
        int angle;
        GL11.glDisable((int)3553);
        GL11.glBegin((int)4);
        int resolution = 10;
        float dToR = (float)Math.PI / 180;
        double prevX = (double)xCenter + (double)r * Math.cos((float)(angle - resolution) * dToR);
        double prevY = (double)yCenter + (double)r * Math.sin((float)(angle - resolution) * dToR);
        for (angle = 0; angle < 360; angle += resolution) {
            double x = (double)xCenter + (double)r * Math.cos((float)angle * dToR);
            double y = (double)yCenter + (double)r * Math.sin((float)angle * dToR);
            GL11.glVertex2f((float)xCenter, (float)yCenter);
            GL11.glVertex2d((double)x, (double)y);
            GL11.glVertex2d((double)prevX, (double)prevY);
            prevX = x;
            prevY = y;
        }
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    public static void drawCylinder(float xCenter, float yCenter, float zCenter, float r, float length, float xTextureStart, float yTextureStart, float xTextureEnd, float yTextureEnd) {
        int ltd = 0;
        float dToR = (float)Math.PI / 180;
        int reso = 20;
        GL11.glBegin((int)7);
        for (ltd = 0; ltd < 360; ltd += reso) {
            float x = (float)((double)xCenter + Math.sin((float)ltd * dToR) * (double)r);
            float z = (float)((double)zCenter + Math.cos((float)ltd * dToR) * (double)r);
            float x2 = (float)((double)xCenter + Math.sin((float)(ltd + reso) * dToR) * (double)r);
            float z2 = (float)((double)zCenter + Math.cos((float)(ltd + reso) * dToR) * (double)r);
            GL11.glTexCoord2f((float)xTextureStart, (float)yTextureStart);
            GL11.glVertex3f((float)x2, (float)yCenter, (float)z2);
            GL11.glTexCoord2f((float)xTextureEnd, (float)yTextureStart);
            GL11.glVertex3f((float)x2, (float)(yCenter + length), (float)z2);
            GL11.glTexCoord2f((float)xTextureEnd, (float)yTextureEnd);
            GL11.glVertex3f((float)x, (float)(yCenter + length), (float)z);
            GL11.glTexCoord2f((float)xTextureStart, (float)yTextureEnd);
            GL11.glVertex3f((float)x, (float)yCenter, (float)z);
        }
        GL11.glEnd();
    }

    public static void renderSide(Vector3fMax vector, EnumFacing dir) {
        if (dir == EnumFacing.UP) {
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        }
        if (dir == EnumFacing.DOWN) {
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        }
        if (dir == EnumFacing.WEST) {
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        }
        if (dir == EnumFacing.EAST) {
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        }
        if (dir == EnumFacing.NORTH) {
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        }
        if (dir == EnumFacing.SOUTH) {
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
            GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
        }
    }

    public static void drawCubeWithLines(int size, boolean isActive, float rF, float gF, float bF) {
        float minPP = pixel * (float)(size + 1);
        float minNP = pixel * (float)size;
        float maxPP = pixel * (float)(16 - (size + 1));
        float maxNP = pixel * (float)(16 - size);
        Vector3fMax vNS = new Vector3fMax(minPP, minPP, minNP, maxPP, maxPP, maxNP);
        Vector3fMax vEW = new Vector3fMax(minNP, minPP, minPP, maxNP, maxPP, maxPP);
        Vector3fMax vTB = new Vector3fMax(minPP, minNP, minPP, maxPP, maxNP, maxPP);
        GL11.glColor3f((float)rF, (float)gF, (float)bF);
        RenderHelper.renderSide(vNS, EnumFacing.NORTH);
        RenderHelper.renderSide(vNS, EnumFacing.SOUTH);
        RenderHelper.renderSide(vEW, EnumFacing.EAST);
        RenderHelper.renderSide(vEW, EnumFacing.WEST);
        RenderHelper.renderSide(vTB, EnumFacing.UP);
        RenderHelper.renderSide(vTB, EnumFacing.DOWN);
        if (!isActive) {
            GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        } else {
            GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        }
        Vector3fMax vEWS = new Vector3fMax(minNP, minNP, minNP, maxNP, maxNP, minPP);
        Vector3fMax vEWN = new Vector3fMax(minNP, minNP, maxPP, maxNP, maxNP, maxNP);
        Vector3fMax vEWT = new Vector3fMax(minNP, maxPP, minPP, maxNP, maxNP, maxPP);
        Vector3fMax vEWB = new Vector3fMax(minNP, minNP, minPP, maxNP, minPP, maxPP);
        Vector3fMax vNSW = new Vector3fMax(minNP, minNP, minNP, minPP, maxNP, maxNP);
        Vector3fMax vNSE = new Vector3fMax(maxPP, minNP, minNP, maxNP, maxNP, maxNP);
        Vector3fMax vNST = new Vector3fMax(minPP, maxPP, minNP, maxPP, maxNP, maxNP);
        Vector3fMax vNSB = new Vector3fMax(minPP, minNP, minNP, maxPP, minPP, maxNP);
        Vector3fMax vTBW = new Vector3fMax(minNP, minNP, minNP, minPP, maxNP, maxNP);
        Vector3fMax vTBE = new Vector3fMax(maxPP, minNP, minNP, maxNP, maxNP, maxNP);
        Vector3fMax vTBN = new Vector3fMax(minPP, minNP, minNP, maxPP, maxNP, minPP);
        Vector3fMax vTBS = new Vector3fMax(minPP, minNP, maxPP, maxPP, maxNP, maxNP);
        RenderHelper.renderSide(vEWS, EnumFacing.EAST);
        RenderHelper.renderSide(vEWS, EnumFacing.WEST);
        RenderHelper.renderSide(vEWN, EnumFacing.EAST);
        RenderHelper.renderSide(vEWN, EnumFacing.WEST);
        RenderHelper.renderSide(vEWT, EnumFacing.EAST);
        RenderHelper.renderSide(vEWT, EnumFacing.WEST);
        RenderHelper.renderSide(vEWB, EnumFacing.EAST);
        RenderHelper.renderSide(vEWB, EnumFacing.WEST);
        RenderHelper.renderSide(vNSW, EnumFacing.NORTH);
        RenderHelper.renderSide(vNSW, EnumFacing.SOUTH);
        RenderHelper.renderSide(vNSE, EnumFacing.NORTH);
        RenderHelper.renderSide(vNSE, EnumFacing.SOUTH);
        RenderHelper.renderSide(vNST, EnumFacing.NORTH);
        RenderHelper.renderSide(vNST, EnumFacing.SOUTH);
        RenderHelper.renderSide(vNSB, EnumFacing.NORTH);
        RenderHelper.renderSide(vNSB, EnumFacing.SOUTH);
        RenderHelper.renderSide(vTBW, EnumFacing.UP);
        RenderHelper.renderSide(vTBW, EnumFacing.DOWN);
        RenderHelper.renderSide(vTBE, EnumFacing.UP);
        RenderHelper.renderSide(vTBE, EnumFacing.DOWN);
        RenderHelper.renderSide(vTBN, EnumFacing.UP);
        RenderHelper.renderSide(vTBN, EnumFacing.DOWN);
        RenderHelper.renderSide(vTBS, EnumFacing.UP);
        RenderHelper.renderSide(vTBS, EnumFacing.DOWN);
    }

    public static void drawWhiteCube(Vector3fMax vector) {
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMin());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMin(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMax(), (float)vector.getYMax(), (float)vector.getZMax());
        GL11.glVertex3f((float)vector.getXMin(), (float)vector.getYMax(), (float)vector.getZMax());
    }

    public static void drawGL11SideTopWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g());
    }

    public static void drawGL11SideBottomWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g());
    }

    public static void drawGL11SideWestWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94210_h());
    }

    public static void drawGL11SideEastWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h());
    }

    public static void drawGL11SideNorthWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMin(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMin(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMin(), icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMin(), icon.func_94209_e(), icon.func_94210_h());
    }

    public static void drawGL11SideSouthWithTexture(Vector3fMax vector, TextureAtlasSprite icon) {
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMin(), vector.getZMax(), icon.func_94212_f(), icon.func_94210_h());
        RenderHelper.vertexWithTexture(vector.getXMax(), vector.getYMax(), vector.getZMax(), icon.func_94212_f(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMax(), vector.getZMax(), icon.func_94209_e(), icon.func_94206_g());
        RenderHelper.vertexWithTexture(vector.getXMin(), vector.getYMin(), vector.getZMax(), icon.func_94209_e(), icon.func_94210_h());
    }

    public static int computeGuiScale() {
        Minecraft mc = Minecraft.func_71410_x();
        int scaleFactor = 1;
        int k = mc.field_71474_y.field_74335_Z;
        if (k == 0) {
            k = 1000;
        }
        while (scaleFactor < k && mc.field_71443_c / (scaleFactor + 1) >= 320 && mc.field_71440_d / (scaleFactor + 1) >= 240) {
            ++scaleFactor;
        }
        return scaleFactor;
    }
}

