/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg.commands;

import com.brandon3055.csg.DataManager;
import com.brandon3055.csg.LogHelper;
import com.brandon3055.csg.lib.PlayerSlot;
import com.brandon3055.csg.lib.StackReference;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class CommandKits
extends CommandBase {
    public int func_82362_a() {
        return 2;
    }

    public String func_71517_b() {
        return "csg_kit";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/csg_kit";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.help(sender);
            return;
        }
        if (args[0].equals("add") && args.length == 2) {
            ItemStack stack;
            int i;
            EntityPlayerMP player = CommandKits.func_71521_c((ICommandSender)sender);
            HashMap<PlayerSlot, StackReference> newKit = new HashMap<PlayerSlot, StackReference>();
            String name = args[1];
            for (i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack.func_190926_b()) continue;
                newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.MAIN), new StackReference(stack));
            }
            for (i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                stack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
                if (stack.func_190926_b()) continue;
                newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.ARMOR), new StackReference(stack));
            }
            for (i = 0; i < player.field_71071_by.field_184439_c.size(); ++i) {
                stack = (ItemStack)player.field_71071_by.field_184439_c.get(i);
                if (stack.func_190926_b()) continue;
                newKit.put(new PlayerSlot(i, PlayerSlot.EnumInvCategory.OFF_HAND), new StackReference(stack));
            }
            DataManager.kits.put(name, newKit);
            try {
                DataManager.saveConfig();
            }
            catch (IOException e) {
                LogHelper.error("Something when wrong while saving inventory!");
                e.printStackTrace();
                throw new CommandException(e.getMessage() + " [See console for stacktrace]", new Object[0]);
            }
            sender.func_145747_a(new TextComponentString("Your current inventory has been saved to kit " + name).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        } else if (args[0].equals("give") && args.length > 1) {
            String kit = args[1];
            if (!DataManager.kits.containsKey(kit)) {
                throw new CommandException("The specified kit does not exist!", new Object[0]);
            }
            EntityPlayerMP player = args.length >= 3 ? CommandKits.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]) : CommandKits.func_71521_c((ICommandSender)sender);
            DataManager.givePlayerKit((EntityPlayer)player, kit);
        } else if (args[0].equals("remove") && args.length == 2) {
            String kit = args[1];
            if (!DataManager.kits.containsKey(kit)) {
                throw new CommandException("The specified kit does not exist!", new Object[0]);
            }
            DataManager.kits.remove(kit);
            try {
                DataManager.saveConfig();
            }
            catch (IOException e) {
                LogHelper.error("Something when wrong while saving inventory!");
                e.printStackTrace();
                throw new CommandException(e.getMessage() + " [See console for stacktrace]", new Object[0]);
            }
            sender.func_145747_a(new TextComponentString("Kit removed successfully!").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        } else if (args[0].equals("list")) {
            sender.func_145747_a(new TextComponentString("### Kits ###").func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
            for (String name : DataManager.kits.keySet()) {
                sender.func_145747_a(new TextComponentString(name).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            }
        } else {
            this.help(sender);
        }
    }

    private void help(ICommandSender sender) {
        sender.func_145747_a((ITextComponent)new TextComponentString("Usage:"));
        sender.func_145747_a((ITextComponent)new TextComponentString("/csg_kit add <kit name>"));
        sender.func_145747_a(new TextComponentString("- adds/overwrite the specified kit with your current player inventory.").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        sender.func_145747_a((ITextComponent)new TextComponentString("/csg_kit give <kit name> [player]"));
        sender.func_145747_a(new TextComponentString("- Give the specified kit to the target player or your self if no player is specified (Will delete all existing items first.)").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        sender.func_145747_a((ITextComponent)new TextComponentString("/csg_kit remove <kit name>"));
        sender.func_145747_a(new TextComponentString("- Removes the specified kit from the system.").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
        sender.func_145747_a((ITextComponent)new TextComponentString("/csg_kit list"));
        sender.func_145747_a(new TextComponentString("- lists all kits.").func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandKits.func_71530_a((String[])args, (String[])new String[]{"add", "give", "remove", "list"});
        }
        if (args.length == 2 && (args[0].equals("give") || args[0].equals("remove"))) {
            return CommandKits.func_175762_a((String[])args, DataManager.kits.keySet());
        }
        if (args.length == 3 && args[0].equals("give")) {
            return CommandKits.func_71530_a((String[])args, (String[])server.func_184103_al().func_72369_d());
        }
        return Collections.emptyList();
    }
}

